/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import java.util.List;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.validators.ValueRequiredValidator;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ListingElement;
import org.eclipse.birt.report.model.elements.interfaces.IGroupElementModel;
import org.eclipse.birt.report.model.elements.strategy.GroupPropSearchStrategy;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GroupElement
extends DesignElement
implements IGroupElementModel {
    private static final int LEVEL_NOT_SET = -1;
    protected int groupLevel = -1;

    public GroupElement() {
        this.initSlots();
        this.cachedPropStrategy = GroupPropSearchStrategy.getInstance();
    }

    @Override
    public ContainerSlot getSlot(int slot) {
        assert (slot >= 0 && slot < 2);
        return this.slots[slot];
    }

    public int getGroupLevel() {
        DesignElement container = this.getContainer();
        this.groupLevel = container == null ? -1 : this.getContainerInfo().indexOf(this) + 1;
        return this.groupLevel;
    }

    @Override
    public List<SemanticException> validate(Module module) {
        List<SemanticException> list = super.validate(module);
        list.addAll(this.validateStructureList(module, "sort"));
        list.addAll(this.validateStructureList(module, "filter"));
        list.addAll(ValueRequiredValidator.getInstance().validate(module, this, "keyExpr"));
        return list;
    }

    @Override
    protected String getNameForDisplayLabel() {
        ElementPropertyDefn propDefn = (ElementPropertyDefn)this.getDefn().getProperty("groupName");
        return (String)this.getStrategy().getPropertyFromElement(null, this, propDefn);
    }

    @Override
    public Object getFactoryProperty(Module module, ElementPropertyDefn prop) {
        if (!prop.isStyleProperty()) {
            return super.getFactoryProperty(module, prop);
        }
        return this.getStrategy().getPropertyFromElement(module, this, prop);
    }

    @Override
    public boolean canDrop(Module module) {
        boolean retValue = super.canDrop(module);
        if (!retValue) {
            return retValue;
        }
        return !this.isReferredDataGroup(module);
    }

    private boolean isReferredDataGroup(Module module) {
        ListingElement tmpContainer = (ListingElement)this.getContainer();
        if (tmpContainer == null) {
            return false;
        }
        return tmpContainer.isDataBindingReferring(module);
    }
}

