/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.emitter;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.layout.area.IContainerArea;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.layout.pdf.emitter.BlockStackingLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.ContainerLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.LayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.emitter.PDFLayoutEmitter;

public class RegionLayout
extends BlockStackingLayout {
    public RegionLayout(LayoutEngineContext context, IContent content, IContainerArea container) {
        super(context, null, content);
        this.currentContext = new ContainerLayout.ContainerContext();
        this.contextList.add(this.currentContext);
        this.currentContext.root = container != null ? (ContainerArea)container : (ContainerArea)AreaFactory.createLogicContainer(content.getReportContent());
        this.currentContext.maxAvaWidth = this.currentContext.root.getContentWidth();
        this.currentContext.maxAvaHeight = Integer.MAX_VALUE;
    }

    protected void initialize() {
        this.createRoot();
        this.currentContext.maxAvaWidth = this.currentContext.root.getContentWidth();
        this.currentContext.maxAvaHeight = Integer.MAX_VALUE;
    }

    public void layout() throws BirtException {
        this.initialize();
        PDFLayoutEmitter emitter = new PDFLayoutEmitter(this.context);
        emitter.current = this;
        this.visitContent(this.content, emitter);
        this.closeLayout();
    }

    protected void createRoot() {
        if (this.currentContext.root == null) {
            this.currentContext.root = (ContainerArea)AreaFactory.createLogicContainer(this.content.getReportContent());
        }
    }

    protected void closeLayout() {
        this.currentContext.root.setHeight(Math.max(this.currentContext.currentBP, this.currentContext.root.getHeight()));
    }
}

