/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.wpml;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IListGroupContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.emitter.ContentEmitterAdapter;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.emitter.wpml.AbstractEmitterImpl;
import org.eclipse.birt.report.engine.emitter.wpml.DocEmitterImpl;
import org.eclipse.birt.report.engine.internal.content.wrap.TableContentWrapper;
import org.eclipse.birt.report.engine.presentation.ContentEmitterVisitor;

public class DocEmitter
extends ContentEmitterAdapter {
    private static Logger logger = Logger.getLogger(DocEmitter.class.getName());
    public static final int MAX_COLUMN = 63;
    protected AbstractEmitterImpl emitterImplement = null;
    protected ContentEmitterVisitor contentVisitor = new ContentEmitterVisitor(this);
    private int omitCellLayer = 0;
    private boolean isClipped = false;

    public DocEmitter() {
        this.createEmitterImplement();
    }

    protected void createEmitterImplement() {
        this.emitterImplement = new DocEmitterImpl(this.contentVisitor);
    }

    public void initialize(IEmitterServices service) throws EngineException {
        this.emitterImplement.initialize(service);
    }

    public String getOutputFormat() {
        return this.emitterImplement.getOutputFormat();
    }

    public void startPage(IPageContent page) throws BirtException {
        try {
            this.emitterImplement.startPage(page);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    public void end(IReportContent report) throws BirtException {
        try {
            this.emitterImplement.end(report);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    public void endCell(ICellContent cell) {
        if (this.omitCellLayer != 0) {
            --this.omitCellLayer;
            if (this.omitCellLayer == 0) {
                this.isClipped = false;
            }
            return;
        }
        this.emitterImplement.endCell(cell);
    }

    public void endContainer(IContainerContent container) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.endContainer(container);
    }

    public void startContainer(IContainerContent container) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.startContainer(container);
    }

    public void endContent(IContent content) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.endContent(content);
    }

    public void endGroup(IGroupContent group) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.endGroup(group);
    }

    public void accountPageProp(IPageContent page) {
        this.emitterImplement.computePageProperties(page);
    }

    public void endList(IListContent list) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.endList(list);
    }

    public void endListBand(IListBandContent listBand) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.endListBand(listBand);
    }

    public void endListGroup(IListGroupContent group) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.endListGroup(group);
    }

    public void endPage(IPageContent page) {
        this.emitterImplement.endPage(page);
    }

    public void endRow(IRowContent row) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.endRow(row);
    }

    public void endTable(ITableContent table) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.endTable(table);
    }

    public void endTableBand(ITableBandContent band) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.endTableBand(band);
    }

    public void endTableGroup(ITableGroupContent group) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.endTableGroup(group);
    }

    public void start(IReportContent report) {
        this.emitterImplement.start(report);
    }

    public void startAutoText(IAutoTextContent autoText) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.startAutoText(autoText);
    }

    public void startCell(ICellContent cell) {
        if (this.isClipped) {
            ++this.omitCellLayer;
            return;
        }
        int colCount = cell.getColumn();
        if (colCount >= 63) {
            ++this.omitCellLayer;
            this.isClipped = true;
            return;
        }
        this.emitterImplement.startCell(cell);
    }

    public void startContent(IContent content) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.startContent(content);
    }

    public void startData(IDataContent data) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.startData(data);
    }

    public void startForeign(IForeignContent foreign) throws BirtException {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.startForeign(foreign);
    }

    public void startGroup(IGroupContent group) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.startGroup(group);
    }

    public void startImage(IImageContent image) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.startImage(image);
    }

    public void startLabel(ILabelContent label) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.startLabel(label);
    }

    public void startList(IListContent list) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.startList(list);
    }

    public void startListBand(IListBandContent listBand) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.startListBand(listBand);
    }

    public void startListGroup(IListGroupContent group) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.startListGroup(group);
    }

    public void startRow(IRowContent row) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.startRow(row);
    }

    public void startTable(ITableContent table) {
        if (this.isClipped) {
            return;
        }
        int colCount = table.getColumnCount();
        if (colCount > 63) {
            table = this.getPartTable(table);
            logger.log(Level.WARNING, "There are too many columns in the table , just output the first 63 columns");
        }
        this.emitterImplement.startTable(table);
    }

    private ITableContent getPartTable(ITableContent table) {
        List columns = table.getColumns();
        columns = columns.subList(0, 63);
        TableContentWrapper content = new TableContentWrapper(table, columns);
        return content;
    }

    public void startTableBand(ITableBandContent band) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.startTableBand(band);
    }

    public void startTableGroup(ITableGroupContent group) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.startTableGroup(group);
    }

    public void startText(ITextContent text) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.startText(text);
    }
}

