/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.excel.impl.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.eclipse.birt.report.data.oda.excel.impl.i18n.Messages;
import org.eclipse.birt.report.data.oda.excel.impl.util.ResourceLocatorUtil;
import org.eclipse.birt.report.data.oda.excel.impl.util.XlsxFileReader;
import org.eclipse.birt.report.data.oda.excel.impl.util.XlsxRowCallBack;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.xml.sax.SAXException;

public class ExcelFileReader {
    private InputStream fis;
    private String fileExtension;
    private List<String> workSheetList;
    LinkedHashMap<String, String> xlsxWorkSheetList;
    private int currentSheetIndex = 0;
    private Workbook workBook;
    private Sheet sheet;
    private FormulaEvaluator formulaEvaluator;
    private boolean isInitialised;
    private int maxRowsInAllSheet;
    private int maxRowsInThisSheet;
    private int currentRowIndex = 0;
    private int maxColumnIndex = 0;
    private int xlsxRowsToRead;
    private XlsxRowCallBack callback;
    private XlsxFileReader xlsxread;
    Map<String, String> xlsxSheetRidNameMap;

    public void setCurrentRowIndex(int currentRowIndex) {
        this.currentRowIndex = currentRowIndex;
    }

    public void setMaxColumnIndex(int maxColumnIndex) {
        this.maxColumnIndex = maxColumnIndex;
    }

    public ExcelFileReader(InputStream fis, String fileExtension, List<String> sheetNameList, int rowsToRead) {
        this.fis = fis;
        this.fileExtension = fileExtension;
        this.workSheetList = sheetNameList;
        this.xlsxRowsToRead = rowsToRead;
    }

    public boolean checkXlsEndOfRows() {
        int cnt = this.currentRowIndex + 1;
        while (cnt <= this.currentRowIndex + 5) {
            Row row = this.sheet.getRow(cnt);
            if (row != null) {
                if (this.maxColumnIndex == 0) {
                    this.maxColumnIndex = row.getLastCellNum();
                }
                int colIx = 0;
                while (colIx < this.maxColumnIndex) {
                    Cell cell = row.getCell(colIx);
                    String cellVal = this.getCellValue(cell);
                    if (cell != null && cellVal != null && !"".equals(cellVal)) {
                        return false;
                    }
                    colIx = (short)(colIx + 1);
                }
            }
            ++cnt;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<String> readLine() throws IOException, OdaException {
        if (!this.isInitialised) {
            this.initialise();
        }
        if (this.currentRowIndex >= this.maxRowsInThisSheet && !this.initialiseNextSheet()) {
            return null;
        }
        ArrayList<String> rowData = new ArrayList();
        if (ExcelFileReader.isXlsFile(this.fileExtension)) {
            Row row = this.sheet.getRow(this.currentRowIndex);
            if (row == null) return null;
            if (this.maxColumnIndex == 0) {
                this.maxColumnIndex = row.getLastCellNum();
            }
            boolean blankRow = true;
            int colIx = 0;
            while (colIx < this.maxColumnIndex) {
                Cell cell = row.getCell(colIx);
                String cellVal = this.getCellValue(cell);
                if (cell != null && cellVal != null && !cellVal.equals("")) {
                    blankRow = false;
                }
                rowData.add(cellVal);
                colIx = (short)(colIx + 1);
            }
            if (blankRow && this.checkXlsEndOfRows()) {
                return null;
            }
        } else if (ExcelFileReader.isXlsxFile(this.fileExtension)) {
            rowData = this.callback.getRow(this.currentRowIndex);
        }
        ++this.currentRowIndex;
        return rowData;
    }

    public void close() throws IOException {
        this.fis.close();
    }

    private void initialise() throws IOException, OdaException {
        try {
            if (ExcelFileReader.isXlsxFile(this.fileExtension)) {
                this.xlsxread = new XlsxFileReader(this.fis);
                this.callback = new XlsxRowCallBack();
                this.xlsxSheetRidNameMap = this.xlsxread.getSheetNames();
                for (String sheetName : this.workSheetList) {
                    String rid = this.xlsxSheetRidNameMap.get(sheetName);
                    if (rid == null) {
                        throw new OdaException(Messages.getString("invalid_sheet_name"));
                    }
                    this.xlsxread.processSheet(rid, this.callback, this.xlsxRowsToRead);
                    this.maxRowsInAllSheet = this.callback.getMaxRowsInSheet();
                    this.maxRowsInThisSheet = this.callback.getMaxRowsInSheet();
                }
            } else if (ExcelFileReader.isXlsFile(this.fileExtension)) {
                if (this.workBook == null) {
                    this.workBook = new HSSFWorkbook(this.fis);
                }
                this.formulaEvaluator = this.workBook.getCreationHelper().createFormulaEvaluator();
                this.workBook.setMissingCellPolicy(Row.RETURN_NULL_AND_BLANK);
                this.sheet = this.workBook.getSheet(this.workSheetList.get(this.currentSheetIndex));
                if (this.sheet == null) {
                    throw new OdaException(Messages.getString("invalid_sheet_name"));
                }
                this.maxRowsInThisSheet = this.sheet.getPhysicalNumberOfRows();
                for (String sheetName : this.workSheetList) {
                    Sheet localSheet = this.workBook.getSheet(sheetName);
                    this.maxRowsInAllSheet += localSheet.getPhysicalNumberOfRows();
                }
            }
            this.isInitialised = true;
        }
        catch (NullPointerException e) {
            throw new OdaException((Throwable)e);
        }
        catch (OpenXML4JException e) {
            throw new OdaException((Throwable)e);
        }
        catch (SAXException e) {
            if (e.getMessage().equalsIgnoreCase("Row Limit Reached")) {
                this.maxRowsInThisSheet = this.callback.getMaxRowsInSheet();
                this.isInitialised = true;
            }
            throw new OdaException((Throwable)e);
        }
    }

    private boolean initialiseNextSheet() throws IOException, OdaException {
        if (this.workSheetList.size() <= ++this.currentSheetIndex) {
            return false;
        }
        if (ExcelFileReader.isXlsxFile(this.fileExtension)) {
            return false;
        }
        if (ExcelFileReader.isXlsFile(this.fileExtension)) {
            do {
                this.sheet = this.workBook.getSheet(this.workSheetList.get(this.currentSheetIndex));
                this.maxRowsInThisSheet = this.sheet.getPhysicalNumberOfRows();
            } while (this.maxRowsInThisSheet == 0 && this.workSheetList.size() < ++this.currentSheetIndex);
        }
        if (this.maxRowsInThisSheet == 0) {
            return false;
        }
        this.currentRowIndex = 0;
        return true;
    }

    private static boolean isXlsxFile(String extension) {
        return extension.equals("xlsx");
    }

    private static boolean isXlsFile(String extension) {
        return extension.equals("xls");
    }

    public static String getExtensionName(Object ri, String path) throws OdaException {
        URI uri = ResourceLocatorUtil.resolvePath(ri, path);
        return ExcelFileReader.getExtensionName(uri);
    }

    public static String getExtensionName(Object uri) {
        InputStream xlsxIs = null;
        InputStream xlsIs = null;
        try {
            xlsxIs = ResourceLocatorUtil.getURIStream(uri);
            new XlsxFileReader(xlsxIs);
            return "xlsx";
        }
        catch (Exception exception) {
            try {
                xlsIs = ResourceLocatorUtil.getURIStream(uri);
                return "xls";
            }
            catch (Exception exception2) {
            }
        }
        finally {
            try {
                if (xlsIs != null) {
                    xlsIs.close();
                }
                if (xlsxIs != null) {
                    xlsxIs.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return "unSupportFormat";
    }

    public String getCellValue(Cell cell) {
        if (cell == null) {
            return "";
        }
        if (cell.getCellType() == 2) {
            return this.resolveFormula(cell);
        }
        if (cell.getCellType() == 0) {
            if (HSSFDateUtil.isCellDateFormatted(cell)) {
                Date myjavadate = HSSFDateUtil.getJavaDate(cell.getNumericCellValue());
                long millis = myjavadate.getTime();
                return Long.toString(millis);
            }
            return Double.valueOf(cell.getNumericCellValue()).toString();
        }
        return cell.toString();
    }

    private String resolveFormula(Cell cell) {
        if (this.formulaEvaluator == null) {
            return cell.toString();
        }
        switch (this.formulaEvaluator.evaluateFormulaCell(cell)) {
            case 4: {
                return Boolean.valueOf(cell.getBooleanCellValue()).toString();
            }
            case 0: {
                if (DateUtil.isCellDateFormatted(cell)) {
                    Date myjavadate = DateUtil.getJavaDate(cell.getNumericCellValue());
                    long millis = myjavadate.getTime();
                    return Long.toString(millis);
                }
                return Double.valueOf(cell.getNumericCellValue()).toString();
            }
            case 1: {
                return cell.getStringCellValue();
            }
        }
        return null;
    }

    public int getMaxRows() throws IOException, OdaException {
        if (!this.isInitialised) {
            this.initialise();
        }
        return this.maxRowsInAllSheet;
    }

    /*
     * Unable to fully structure code
     */
    public static List<String> getSheetNamesInExcelFile(Object file) throws MalformedURLException, IOException {
        extension = ExcelFileReader.getExtensionName(file);
        fis = ResourceLocatorUtil.getURIStream(file);
        sheetNames = new ArrayList<String>();
        try {
            try {
                if (ExcelFileReader.isXlsxFile(extension)) {
                    poiRdr = new XlsxFileReader(fis);
                    lxlsxWorkSheetList = poiRdr.getSheetNames();
                    for (Map.Entry<String, String> entry : lxlsxWorkSheetList.entrySet()) {
                        sheetNames.add(entry.getKey());
                    }
                } else if (ExcelFileReader.isXlsFile(extension)) {
                    lworkBook = new HSSFWorkbook(fis);
                    i = 0;
                    while (i < lworkBook.getNumberOfSheets()) {
                        sheetNames.add(lworkBook.getSheetName(i));
                        ++i;
                    }
                }
            }
            catch (FileNotFoundException v0) {
                fis.close();
            }
            catch (IOException v1) {
                ** try [egrp 2[TRYBLOCK] [4 : 160->161)] { 
lbl28:
                // 1 sources

                fis.close();
            }
            catch (Exception e) {
                e.printStackTrace();
lbl-1000:
                // 2 sources

                {
                    catch (Throwable var8_11) {
                        throw var8_11;
                    }
                }
                fis.close();
            }
        }
        finally {
            fis.close();
        }
        return sheetNames;
    }
}

