/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.aggregation;

import java.util.List;
import java.util.logging.Logger;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.IGroupDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.BaseQuery;
import org.eclipse.birt.data.engine.expression.AggregateExpression;
import org.eclipse.birt.data.engine.expression.AggregationConstantsUtil;
import org.eclipse.birt.data.engine.expression.BytecodeExpression;
import org.eclipse.birt.data.engine.expression.CompiledExpression;
import org.eclipse.birt.data.engine.expression.ConstantExpression;
import org.eclipse.birt.data.engine.impl.aggregation.AggrExprInfo;
import org.eclipse.birt.data.engine.impl.aggregation.AggregateRegistry;
import org.eclipse.birt.data.engine.odi.IQuery;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

final class AggrRegistry
implements AggregateRegistry {
    private int groupLevel;
    private boolean isDetailedRow;
    private int calculationLevel;
    private ScriptContext cx;
    private BaseQuery baseQuery;
    private List groupDefns;
    private int groupCount;
    private Scriptable scope;
    private int runStates;
    private List aggrExprInfoList;
    private static final String TOTAL_COUNT_FUNC = "COUNT";
    private static final String TOTAL_RUNNINGCOUNT_FUNC = "RUNNINGCOUNT";
    private static int PREPARED_QUERY = 1;
    private static int BASE_QUERY = 2;
    private static Logger logger = Logger.getLogger(AggrRegistry.class.getName());

    AggrRegistry(int groupLevel, int calculationLevel, boolean isDetailedRow, ScriptContext cx) throws DataException {
        Object[] params = new Object[]{groupLevel, calculationLevel, isDetailedRow, cx};
        logger.entering(AggrRegistry.class.getName(), "AggrRegistry", params);
        this.groupLevel = groupLevel;
        this.isDetailedRow = isDetailedRow;
        this.calculationLevel = calculationLevel;
        this.cx = cx;
        if (this.calculationLevel < this.groupLevel && this.calculationLevel > 0) {
            throw new DataException("data.engine.InvalidTotalFunc");
        }
        logger.exiting(AggrRegistry.class.getName(), "AggrRegistry");
    }

    void prepare(List groupDefns, Scriptable scope, BaseQuery baseQuery, List aggrExprInfoList) {
        this.groupDefns = groupDefns;
        this.scope = scope;
        this.baseQuery = baseQuery;
        this.aggrExprInfoList = aggrExprInfoList;
        this.runStates = baseQuery == null ? PREPARED_QUERY : BASE_QUERY;
        if (groupDefns != null) {
            this.groupCount = groupDefns.size();
        }
    }

    public int register(AggregateExpression expr) throws DataException {
        return this.registerExpression(expr, this.groupLevel, this.calculationLevel, this.isDetailedRow, this.cx);
    }

    private int registerExpression(AggregateExpression expr, int groupLevel, int calculationLevel, boolean isDetailedRow, ScriptContext cx) throws DataException {
        AggrExprInfo info = this.newAggrExprInfo(expr, groupLevel, calculationLevel, isDetailedRow, cx);
        int id = 0;
        while (id < this.aggrExprInfoList.size()) {
            if (info.equals(this.aggrExprInfoList.get(id))) break;
            ++id;
        }
        if (id == this.aggrExprInfoList.size()) {
            this.aggrExprInfoList.add(info);
        }
        expr.setRegId(id);
        return id;
    }

    private AggrExprInfo newAggrExprInfo(AggregateExpression expr, int currentGroupLevel, int calculationLevel, boolean isDetailedRow, ScriptContext cx) throws DataException {
        int nArgs;
        int nFixedArgs;
        boolean isTotalCountOrRunningCount;
        List exprArgs;
        AggrExprInfo aggr;
        block26: {
            block27: {
                aggr = new AggrExprInfo();
                assert (expr != null);
                assert (currentGroupLevel >= 0);
                aggr.aggregation = expr.getAggregation();
                aggr.calculateLevel = calculationLevel;
                exprArgs = expr.getArguments();
                isTotalCountOrRunningCount = this.isTotalCountOrRunningCount(aggr);
                nFixedArgs = aggr.aggregation.getParameterDefn().length;
                if (!this.isValidArgumentNum(aggr, nFixedArgs, nArgs = exprArgs.size(), isTotalCountOrRunningCount)) {
                    DataException e = new DataException("data.engine.WrongNumAggrArgs", aggr.aggregation.getName());
                    throw e;
                }
                aggr.groupLevel = currentGroupLevel;
                if (!this.containsGroupLevel(aggr, nFixedArgs, nArgs, isTotalCountOrRunningCount)) break block26;
                CompiledExpression groupExpr = (CompiledExpression)exprArgs.get(nArgs - 1);
                if (!(groupExpr instanceof ConstantExpression)) {
                    DataException e = new DataException("data.engine.InvalidAggrGroupExpression", aggr.aggregation.getName());
                    throw e;
                }
                Object groupLevelObj = groupExpr.evaluate(cx, (Scriptable)(this.runStates == BASE_QUERY ? Context.getCurrentContext().initStandardObjects() : this.scope));
                if (groupLevelObj != null) {
                    if (groupLevelObj instanceof String) {
                        int innerMostGroup = 0;
                        innerMostGroup = this.runStates == PREPARED_QUERY ? this.groupCount : (this.baseQuery.getGrouping() != null ? this.baseQuery.getGrouping().length : 0);
                        int groupLevel = AggregationConstantsUtil.getGroupLevel((String)groupLevelObj, currentGroupLevel, innerMostGroup, isDetailedRow);
                        aggr.groupLevel = groupLevel != -1 ? groupLevel : (this.runStates == BASE_QUERY ? this.getGroupIndex(groupLevelObj.toString()) : this.getGroupIndexFromPreparedQuery((String)groupLevelObj));
                    } else if (groupLevelObj instanceof Number) {
                        int offset = ((Number)groupLevelObj).intValue();
                        aggr.groupLevel = offset < 0 ? currentGroupLevel + offset : offset;
                    }
                }
                if (aggr.groupLevel < 0) break block27;
                if (aggr.groupLevel <= (this.runStates == BASE_QUERY ? (this.baseQuery.getGrouping() == null ? 0 : this.baseQuery.getGrouping().length) : this.groupCount)) break block26;
            }
            DataException e = new DataException("data.engine.InvalidGroupLevel", aggr.aggregation.getName());
            throw e;
        }
        if (this.containsFilter(aggr, nFixedArgs, nArgs, isTotalCountOrRunningCount)) {
            aggr.filter = isTotalCountOrRunningCount ? (CompiledExpression)exprArgs.get(nFixedArgs - this.getOptionalArgNum(aggr, nFixedArgs)) : (CompiledExpression)exprArgs.get(nFixedArgs);
            if (aggr.filter instanceof ConstantExpression && ((ConstantExpression)aggr.filter).getValue() == null) {
                aggr.filter = null;
            } else if (aggr.filter instanceof BytecodeExpression) {
                boolean isValid = false;
                int groupLevel = ((BytecodeExpression)aggr.filter).getGroupLevel();
                if (aggr.calculateLevel == -1) {
                    if (groupLevel == 0 || groupLevel == -1) {
                        isValid = true;
                    }
                } else if (groupLevel == -1) {
                    if (aggr.calculateLevel == 0) {
                        isValid = true;
                    }
                } else if (aggr.calculateLevel == groupLevel) {
                    isValid = true;
                }
                if (!isValid) {
                    throw new DataException("data.engine.InvalidTotalFunc");
                }
            }
        }
        if (nFixedArgs > 0 && !aggr.aggregation.getParameterDefn()[0].isOptional() || nArgs == nFixedArgs + 2) {
            aggr.args = new CompiledExpression[nFixedArgs];
            exprArgs.subList(0, nFixedArgs).toArray(aggr.args);
        } else {
            aggr.args = new CompiledExpression[0];
        }
        return aggr;
    }

    private boolean isTotalCountOrRunningCount(AggrExprInfo aggr) {
        return TOTAL_COUNT_FUNC.equalsIgnoreCase(aggr.aggregation.getName()) || TOTAL_RUNNINGCOUNT_FUNC.equalsIgnoreCase(aggr.aggregation.getName());
    }

    private int getOptionalArgNum(AggrExprInfo aggr, int nFixedArgs) {
        int optionalArgNum = 0;
        int i = 0;
        while (i < nFixedArgs) {
            if (aggr.aggregation.getParameterDefn()[i].isOptional()) {
                ++optionalArgNum;
            }
            ++i;
        }
        return optionalArgNum;
    }

    private boolean isValidArgumentNum(AggrExprInfo aggr, int nFixedArgs, int nArgs, boolean isTotalCountOrRunningCount) {
        if (isTotalCountOrRunningCount) {
            return nArgs <= 2;
        }
        return nArgs >= nFixedArgs && nArgs <= nFixedArgs + 2;
    }

    private boolean containsFilter(AggrExprInfo aggr, int nFixedArgs, int nArgs, boolean isTotalCountOrRunningCount) {
        if (isTotalCountOrRunningCount) {
            return nArgs > 0;
        }
        return nArgs > nFixedArgs;
    }

    private boolean containsGroupLevel(AggrExprInfo aggr, int nFixedArgs, int nArgs, boolean isTotalCountOrRunningCount) {
        if (isTotalCountOrRunningCount) {
            return nArgs == 2;
        }
        return nArgs == nFixedArgs + 2;
    }

    private int getGroupIndexFromPreparedQuery(String groupText) {
        assert (groupText != null);
        assert (this.groupDefns != null);
        int i = 0;
        while (i < this.groupDefns.size()) {
            IGroupDefinition group = (IGroupDefinition)this.groupDefns.get(i);
            if (groupText.equals(group.getName()) || groupText.equals(group.getKeyColumn()) || groupText.equals(group.getKeyExpression())) {
                return i + 1;
            }
            ++i;
        }
        return -1;
    }

    private int getGroupIndex(String groupText) {
        assert (groupText != null);
        IQuery.GroupSpec[] groups = this.baseQuery.getGrouping();
        int i = 0;
        while (i < groups.length) {
            IQuery.GroupSpec group = groups[i];
            if (groupText.equals(group.getName()) || groupText.equals(group.getKeyColumn())) {
                return i + 1;
            }
            ++i;
        }
        return -1;
    }
}

