/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util.impl;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.Action;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionHelper {
    protected final DesignElementHandle elementHandle;
    protected final String actionPropName;

    public ActionHelper(DesignElementHandle elementHandle, String propName) {
        this.elementHandle = elementHandle;
        this.actionPropName = propName;
    }

    public ActionHandle getActionHandle() {
        PropertyHandle propHandle = this.elementHandle.getPropertyHandle(this.actionPropName);
        List actions = (List)propHandle.getValue();
        if (actions == null || actions.isEmpty()) {
            return null;
        }
        Action action = (Action)actions.get(0);
        return (ActionHandle)action.getHandle(propHandle);
    }

    public ActionHandle setAction(Action action) throws SemanticException {
        this.elementHandle.setProperty(this.actionPropName, null);
        PropertyHandle propHandle = this.elementHandle.getPropertyHandle(this.actionPropName);
        propHandle.addItem(action);
        List listValue = (List)this.elementHandle.getElement().getProperty(this.elementHandle.getModule(), this.actionPropName);
        Action actionValue = (Action)listValue.get(0);
        if (actionValue == null) {
            return null;
        }
        return (ActionHandle)actionValue.getHandle(propHandle);
    }

    public Iterator<ActionHandle> actionsIterator() {
        PropertyHandle propHandle = this.elementHandle.getPropertyHandle(this.actionPropName);
        assert (propHandle != null);
        return propHandle.iterator();
    }
}

