/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v4;

import java.util.ArrayList;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.internal.document.v4.ContainerExecutor;
import org.eclipse.birt.report.engine.internal.document.v4.MasterPageExecutor;
import org.eclipse.birt.report.engine.internal.document.v4.ReportItemExecutor;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;

public class PageBandExecutor
extends ContainerExecutor {
    private ArrayList contents;
    private int nextItem;

    protected PageBandExecutor(MasterPageExecutor parent, ArrayList contents) {
        super(parent.manager, -1);
        this.parent = parent;
        this.contents = contents;
        this.nextItem = 0;
    }

    public void close() {
        this.nextItem = 0;
        this.contents = null;
        super.close();
    }

    protected IContent doCreateContent() {
        return this.report.createContainerContent();
    }

    protected void doExecute() throws Exception {
    }

    protected ReportItemExecutor doCreateExecutor(long offset) throws Exception {
        int itemCount = this.contents.size();
        if (this.nextItem < itemCount) {
            ReportItemDesign itemDesign = (ReportItemDesign)this.contents.get(this.nextItem);
            ++this.nextItem;
            return this.manager.createExecutor(this, itemDesign, offset);
        }
        return null;
    }

    protected void doSkipToExecutor(InstanceID id, long offset) throws Exception {
        int itemCount = this.contents.size();
        long designId = id.getComponentID();
        int i = 0;
        while (i < itemCount) {
            ReportItemDesign itemDesign = (ReportItemDesign)this.contents.get(i);
            if (designId == itemDesign.getID()) {
                this.nextItem = i;
                return;
            }
            ++i;
        }
        this.nextItem = itemCount;
    }
}

