/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel;

import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.emitter.excel.SheetData;
import org.eclipse.birt.report.engine.emitter.excel.layout.XlsContainer;

public class ImageData
extends SheetData {
    private String altText;
    private String imageUrl;
    private byte[] imageData;
    private int width;
    private int imageHeight;

    public ImageData(IImageContent image, byte[] imageData, int imageWidth, int imageHeight, int styleId, int datatype, XlsContainer currentContainer) {
        this.dataType = datatype;
        this.styleId = styleId;
        this.height = (float)imageHeight / 1000.0f;
        this.imageHeight = (int)this.height;
        this.width = Math.min(currentContainer.getSizeInfo().getWidth(), imageWidth);
        this.altText = image.getAltText();
        this.imageUrl = image.getURI();
        this.imageData = imageData;
        this.rowSpanInDesign = 0;
    }

    public String getDescription() {
        return this.altText;
    }

    public void setDescription(String description) {
        this.altText = description;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setUrl(String url) {
        this.imageUrl = url;
    }

    public byte[] getImageData() {
        return this.imageData;
    }

    public void setImageData(byte[] imageData) {
        this.imageData = imageData;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public int getImageWidth() {
        return this.width / 1000;
    }

    public int getEndX() {
        return this.getStartX() + this.width;
    }
}

