/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc;

import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.birt.report.data.oda.jdbc.SaxParser;

public class DBConfig {
    private static final String CONFIG_XML = "config.xml";
    public static final int NORMAL = 0;
    public static final int EXEC_QUERY_AND_CACHE = 1;
    public static final int EXEC_QUERY_WITHOUT_CACHE = 2;
    public static final int DEFAULT_POLICY = -1;
    public static final int IGNORE_UNIMPORTANT_EXCEPTION = 3;
    private HashMap<Integer, Set<String>> driverPolicy = new HashMap();
    private static DBConfig config = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DBConfig getInstance() {
        if (config != null) return config;
        Class<DBConfig> clazz = DBConfig.class;
        synchronized (DBConfig.class) {
            if (config != null) return config;
            config = new DBConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return config;
        }
    }

    DBConfig() {
        new SaxParser(this).parse();
    }

    public boolean qualifyPolicy(String driverName, int policyNumber) {
        if (driverName == null) {
            return false;
        }
        Set<String> policySet = this.driverPolicy.get(policyNumber);
        if (policySet == null) {
            return false;
        }
        return policySet.contains(driverName.toUpperCase());
    }

    public void putPolicy(String driverName, int policy) {
        if (driverName == null) {
            return;
        }
        if (!this.driverPolicy.containsKey(policy)) {
            this.driverPolicy.put(policy, new HashSet());
        }
        this.driverPolicy.get(policy).add(driverName.toUpperCase());
    }

    public URL getConfigURL() {
        URL u = this.getClass().getResource(CONFIG_XML);
        return u;
    }
}

