/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.excel.impl;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.birt.report.data.oda.excel.ResultSetMetaDataHelper;
import org.eclipse.birt.report.data.oda.excel.impl.ParameterMetaData;
import org.eclipse.birt.report.data.oda.excel.impl.ResultSet;
import org.eclipse.birt.report.data.oda.excel.impl.ResultSetMetaData;
import org.eclipse.birt.report.data.oda.excel.impl.i18n.Messages;
import org.eclipse.birt.report.data.oda.excel.impl.util.DataTypes;
import org.eclipse.birt.report.data.oda.excel.impl.util.ExcelFileSource;
import org.eclipse.birt.report.data.oda.excel.impl.util.querytextutil.QueryTextUtil;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.SortSpec;
import org.eclipse.datatools.connectivity.oda.spec.QuerySpecification;

public class ExcelFileQuery
implements IQuery {
    public static final int DEFAULT_MAX_ROWS_TO_READ = 0;
    private int maxRows;
    private int maxRowsToRead = 0;
    private ExcelFileSource masterExcelFileSource = null;
    private static final String NAME_LITERAL = "NAME";
    private static final String TYPE_LITERAL = "TYPE";
    private boolean hasColumnNames;
    private boolean hasTypeLine;
    private String currentTableName;
    private Properties connProperties;
    private ResultSetMetaData resultSetMetaData;
    private ResultSetMetaDataHelper resultSetMetaDataHelper;
    private String worksheetNames;
    private String preparedColumnNames;
    private String[] columnLabels;
    private boolean isInvalidQuery;
    private Map appContext = null;

    public ExcelFileQuery(Properties connProperties) throws OdaException {
        if (connProperties == null || connProperties.getProperty("URI") == null) {
            throw new OdaException(Messages.getString("common_ARGUMENT_CANNOT_BE_NULL"));
        }
        this.connProperties = connProperties;
        this.extractsHasColumnNamesInfo();
        this.extractsHasColumnTypeLineInfo();
    }

    private void extractsHasColumnNamesInfo() {
        this.hasColumnNames = !this.connProperties.getProperty("INCLCOLUMNNAME").equalsIgnoreCase("NO");
    }

    private void extractsHasColumnTypeLineInfo() {
        this.hasTypeLine = !this.connProperties.getProperty("INCLTYPELINE").equalsIgnoreCase("NO");
    }

    public void prepare(String queryText) throws OdaException {
        if (queryText == null) {
            throw new OdaException(Messages.getString("common_NULL_QUERY_TEXT"));
        }
        QueryTextUtil qtu = new QueryTextUtil(queryText);
        String query = this.formatQueryText(qtu.getQuery());
        this.validateNonEmptyQueryText(query);
        String[] queryFragments = this.parsePreparedQueryText(query);
        this.validateSingleTableQuery(queryFragments);
        this.currentTableName = this.getPreparedTableNames(queryFragments);
        this.preparedColumnNames = this.getPreparedColumnNames(queryFragments);
        this.columnLabels = this.getColumnLabels(queryFragments);
    }

    private String formatQueryText(String queryText) {
        StringBuffer result = new StringBuffer();
        String[] temp = queryText.trim().split(" ");
        int i = 0;
        while (i < temp.length) {
            if (temp[i].equalsIgnoreCase("AS")) {
                temp[i] = temp[i].toUpperCase();
            }
            if (temp[i].equalsIgnoreCase("FROM")) {
                temp[i] = temp[i].toUpperCase();
            }
            if (temp[i].equalsIgnoreCase("SELECT")) {
                temp[i] = temp[i].toUpperCase();
            }
            result.append(temp[i]).append(" ");
            ++i;
        }
        return result.toString().trim();
    }

    private void prepareMetaData() throws OdaException {
        this.masterExcelFileSource = new ExcelFileSource(this.connProperties, this.currentTableName, this.worksheetNames, this.maxRowsToRead, null, null, this.appContext);
        String[] allColumnNames = this.hasColumnNames ? this.discoverActualColumnMetaData(NAME_LITERAL, this.currentTableName) : this.createTempColumnNames(this.masterExcelFileSource.getColumnCount());
        String[] allColumnTypes = this.hasTypeLine ? this.discoverActualColumnMetaData(TYPE_LITERAL, this.currentTableName) : this.createTempColumnTypes(this.masterExcelFileSource.getColumnCount());
        this.resultSetMetaData = new ResultSetMetaData(allColumnNames, allColumnTypes);
        if (allColumnNames.length != allColumnTypes.length) {
            throw new OdaException(Messages.getString("invalid_excelfile_format"));
        }
        String[] queryColumnNames = null;
        String[] queryColumnTypes = null;
        String[] queryColumnLables = null;
        if (this.isWildCard(this.preparedColumnNames)) {
            queryColumnNames = allColumnNames;
            queryColumnTypes = allColumnTypes;
            queryColumnLables = allColumnNames;
            this.resultSetMetaDataHelper = new ResultSetMetaDataHelper(queryColumnNames, queryColumnTypes, queryColumnLables);
            this.resultSetMetaData = new ResultSetMetaData(this.resultSetMetaDataHelper);
        } else {
            queryColumnNames = ExcelFileSource.getStringArrayFromList(this.stripFormatInfoFromQueryColumnNames(this.getQueryColumnNamesVector(this.preparedColumnNames)));
            this.validateColumnName(queryColumnNames, allColumnNames);
            queryColumnTypes = this.hasTypeLine ? this.getQueryColumnTypes(allColumnNames, allColumnTypes, queryColumnNames) : this.createTempColumnTypes(queryColumnNames.length);
            String[] stringArray = queryColumnLables = this.hasColumnNames ? this.columnLabels : queryColumnNames;
            if (queryColumnLables == null) {
                queryColumnLables = queryColumnNames;
            }
            this.resultSetMetaDataHelper = new ResultSetMetaDataHelper(queryColumnNames, queryColumnTypes, queryColumnLables);
            this.resultSetMetaData = new ResultSetMetaData(this.resultSetMetaDataHelper);
        }
    }

    private void validateNonEmptyQueryText(String formattedQuery) throws OdaException {
        if (formattedQuery == null || formattedQuery.length() == 0) {
            throw new OdaException(Messages.getString("query_COMMAND_IS_EMPTY"));
        }
    }

    private String[] parsePreparedQueryText(String formattedQuery) throws OdaException {
        return QueryTextUtil.getQueryMetaData(formattedQuery);
    }

    private Vector<String> getQueryColumnNamesVector(String queryColumnNames) {
        Vector<String> result = new Vector<String>();
        char[] chars = queryColumnNames.toCharArray();
        ArrayList<Integer> indiceList = new ArrayList<Integer>();
        boolean inQuote = false;
        boolean isEscaped = false;
        int beginIndex = 0;
        int endIndex = 0;
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '\"') {
                if (!isEscaped) {
                    inQuote = !inQuote;
                } else {
                    isEscaped = !isEscaped;
                }
            } else if (chars[i] == '\\') {
                isEscaped = !isEscaped;
            } else if (chars[i] == ',' && !inQuote) {
                indiceList.add(new Integer(i));
            }
            ++i;
        }
        if (indiceList.size() > 0) {
            int j = 0;
            while (j < indiceList.size()) {
                endIndex = (Integer)indiceList.get(j);
                result.add(queryColumnNames.substring(beginIndex, endIndex).trim());
                beginIndex = endIndex + 1;
                if (j == indiceList.size() - 1) {
                    result.add(queryColumnNames.substring(beginIndex, queryColumnNames.length()).trim());
                }
                ++j;
            }
        } else {
            result.add(queryColumnNames);
        }
        return result;
    }

    private Vector<String> stripFormatInfoFromQueryColumnNames(Vector<String> queryColumnNames) {
        Vector<String> columnNames = new Vector<String>();
        boolean isEscaped = false;
        int i = 0;
        while (i < queryColumnNames.size()) {
            StringBuffer sb = new StringBuffer();
            char[] chars = queryColumnNames.get(i).toCharArray();
            if (chars[0] != '\"') {
                columnNames.add(queryColumnNames.get(i));
            } else {
                int j = 0;
                while (j < chars.length) {
                    if (chars[j] == '\"') {
                        if (isEscaped) {
                            sb.append(chars[j]);
                            isEscaped = !isEscaped;
                        }
                    } else if (chars[j] == '\\') {
                        if (isEscaped) {
                            sb.append(chars[j]);
                        }
                        isEscaped = !isEscaped;
                    } else {
                        sb.append(chars[j]);
                    }
                    ++j;
                }
                columnNames.add(sb.toString());
            }
            ++i;
        }
        return columnNames;
    }

    private String[] getQueryColumnTypes(String[] allColumnNames, String[] allColumnTypes, String[] queryColumnNames) {
        if (!this.hasTypeLine) {
            return null;
        }
        String[] queryColumnTypes = new String[queryColumnNames.length];
        int i = 0;
        while (i < queryColumnNames.length) {
            int j = 0;
            while (j < allColumnNames.length) {
                if (queryColumnNames[i].trim().equalsIgnoreCase(allColumnNames[j])) {
                    queryColumnTypes[i] = allColumnTypes[j];
                    break;
                }
                ++j;
            }
            ++i;
        }
        return queryColumnTypes;
    }

    private String[] getColumnLabels(String[] queryFragments) {
        String queryColumnLabels = this.getPreparedColumnLabels(queryFragments);
        return queryColumnLabels != null ? queryColumnLabels.split(",") : null;
    }

    private String getPreparedColumnLabels(String[] parsedQueryFragments) {
        return parsedQueryFragments[1];
    }

    private void validateSingleTableQuery(String[] parsedQuerySegments) throws OdaException {
        if (this.getPreparedTableNames(parsedQuerySegments).split(",").length != 1) {
            throw new OdaException(Messages.getString("query_DO_NOT_SUPPORT_CROSS_TABLE_QUERY"));
        }
    }

    private String getPreparedTableNames(String[] parsedQueryFragments) {
        return parsedQueryFragments[2];
    }

    private String getPreparedColumnNames(String[] parsedQueryFragments) {
        return parsedQueryFragments[0];
    }

    private String[] discoverActualColumnMetaData(String metaDataType, String tableName) throws OdaException {
        try {
            List<String> columnNameLine;
            this.masterExcelFileSource.resetRowCounter();
            if (!metaDataType.trim().equalsIgnoreCase(NAME_LITERAL) && !metaDataType.trim().equalsIgnoreCase(TYPE_LITERAL)) {
                throw new OdaException(Messages.getString("query_ARGUMENT_ERROR"));
            }
            if (metaDataType.trim().equalsIgnoreCase(TYPE_LITERAL)) {
                while (this.masterExcelFileSource.isEmptyRow(this.masterExcelFileSource.readLine())) {
                }
            }
            while (this.masterExcelFileSource.isEmptyRow(columnNameLine = this.masterExcelFileSource.readLine())) {
            }
            String[] result = this.masterExcelFileSource.getColumnNameArray(columnNameLine);
            if (metaDataType.trim().equalsIgnoreCase(NAME_LITERAL)) {
                this.validateUniqueName(result);
            }
            if (metaDataType.trim().equalsIgnoreCase(TYPE_LITERAL)) {
                this.validateColumnTypeConsistency(result);
            }
            String[] stringArray = this.trimStringArray(result);
            return stringArray;
        }
        catch (IOException e) {
            throw new OdaException((Throwable)e);
        }
        finally {
            if (this.masterExcelFileSource != null) {
                this.masterExcelFileSource.close();
            }
        }
    }

    private String[] createTempColumnNames(int columnCount) {
        String[] tempColumnNames = new String[columnCount];
        int i = 0;
        while (i < columnCount) {
            tempColumnNames[i] = "COLUMN_" + (i + 1);
            ++i;
        }
        return tempColumnNames;
    }

    private String[] createTempColumnTypes(int columnCount) {
        String[] tempColumnTypes = new String[columnCount];
        int i = 0;
        while (i < columnCount) {
            tempColumnTypes[i] = "STRING";
            ++i;
        }
        return tempColumnTypes;
    }

    private boolean isWildCard(String cCN) {
        return cCN.equalsIgnoreCase("*");
    }

    private void validateUniqueName(String[] aCN) throws OdaException {
        int i = 0;
        while (i < aCN.length) {
            if (this.findOccuranceOfValueInStringArray(aCN[i], aCN) > 1) {
                throw new OdaException(Messages.getString("query_SOURCE_DATA_ERROR"));
            }
            ++i;
        }
    }

    private void validateColumnTypeConsistency(String[] aCT) throws OdaException {
        if (!this.hasTypeLine) {
            return;
        }
        int i = 0;
        while (i < aCT.length) {
            if (!DataTypes.isValidType(aCT[i])) {
                throw new OdaException(String.valueOf(Messages.getString("dataTypes_TYPE_NAME_INVALID")) + aCT[i]);
            }
            ++i;
        }
    }

    private int findOccuranceOfValueInStringArray(String value, String[] array) {
        int count = 0;
        int i = 0;
        while (i < array.length) {
            if (value.trim().equalsIgnoreCase(array[i].trim())) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private String[] trimStringArray(String[] array) {
        String[] result = new String[array.length];
        int i = 0;
        while (i < result.length) {
            result[i] = array[i].trim();
            ++i;
        }
        return result;
    }

    private void validateColumnName(String[] cCN, String[] aCN) throws OdaException {
        int i = 0;
        while (i < cCN.length) {
            if (this.findOccuranceOfValueInStringArray(cCN[i], aCN) != 1) {
                this.isInvalidQuery = true;
                throw new OdaException(Messages.getString("query_COMMAND_NOT_VALID"));
            }
            ++i;
        }
    }

    public void setAppContext(Object context) throws OdaException {
        this.appContext = (Map)context;
    }

    public void close() throws OdaException {
        this.maxRows = 0;
        this.resultSetMetaData = null;
    }

    public IResultSetMetaData getMetaData() throws OdaException {
        if (this.resultSetMetaData == null) {
            this.prepareMetaData();
        }
        return this.resultSetMetaData;
    }

    public IResultSet executeQuery() throws OdaException {
        if (this.isInvalidQuery) {
            throw new OdaException(Messages.getString("query_COMMAND_NOT_VALID"));
        }
        if (this.masterExcelFileSource == null) {
            return new ResultSet(new ExcelFileSource(this.connProperties, this.currentTableName, this.worksheetNames, this.maxRows, this.resultSetMetaData, this.resultSetMetaDataHelper, this.appContext), this.resultSetMetaData);
        }
        if (this.resultSetMetaData != null) {
            this.masterExcelFileSource.setRsmd(this.resultSetMetaData);
        }
        if (this.resultSetMetaDataHelper != null) {
            this.masterExcelFileSource.setRsmdHelper(this.resultSetMetaDataHelper);
        }
        this.masterExcelFileSource.setStatementMaxRows(this.maxRows);
        return new ResultSet(this.masterExcelFileSource, this.resultSetMetaData);
    }

    public void setProperty(String name, String value) throws OdaException {
        if (name.equals("WORKSHEETS")) {
            this.worksheetNames = value;
        }
    }

    public void setMaxRows(int max) throws OdaException {
        this.maxRows = max;
    }

    public int getMaxRows() throws OdaException {
        return this.maxRows;
    }

    public void clearInParameters() throws OdaException {
    }

    public void setInt(String parameterName, int value) throws OdaException {
    }

    public void setInt(int parameterId, int value) throws OdaException {
    }

    public void setDouble(String parameterName, double value) throws OdaException {
    }

    public void setDouble(int parameterId, double value) throws OdaException {
    }

    public void setBigDecimal(String parameterName, BigDecimal value) throws OdaException {
    }

    public void setBigDecimal(int parameterId, BigDecimal value) throws OdaException {
    }

    public void setString(String parameterName, String value) throws OdaException {
        System.out.println(parameterName);
    }

    public void setString(int parameterId, String value) throws OdaException {
        System.out.println(value);
    }

    public void setDate(String parameterName, Date value) throws OdaException {
    }

    public void setDate(int parameterId, Date value) throws OdaException {
    }

    public void setTime(String parameterName, Time value) throws OdaException {
    }

    public void setTime(int parameterId, Time value) throws OdaException {
    }

    public void setTimestamp(String parameterName, Timestamp value) throws OdaException {
    }

    public void setTimestamp(int parameterId, Timestamp value) throws OdaException {
    }

    public void setBoolean(String parameterName, boolean value) throws OdaException {
    }

    public void setBoolean(int parameterId, boolean value) throws OdaException {
    }

    public void setObject(String parameterName, Object value) throws OdaException {
    }

    public void setObject(int parameterId, Object value) throws OdaException {
    }

    public void setNull(String parameterName) throws OdaException {
    }

    public void setNull(int parameterId) throws OdaException {
    }

    public int findInParameter(String parameterName) throws OdaException {
        return 0;
    }

    public IParameterMetaData getParameterMetaData() throws OdaException {
        return new ParameterMetaData();
    }

    public void setSortSpec(SortSpec sortBy) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public SortSpec getSortSpec() throws OdaException {
        return null;
    }

    public void setSpecification(QuerySpecification querySpec) throws OdaException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public QuerySpecification getSpecification() {
        return null;
    }

    public String getEffectiveQueryText() {
        throw new UnsupportedOperationException();
    }

    public void cancel() throws OdaException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Properties getConnectionProperties() {
        return this.connProperties;
    }
}

