/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.impl.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.olap.OLAPException;
import javax.olap.cursor.CubeCursor;
import org.eclipse.birt.core.data.IDimLevel;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.ExpressionCompilerUtil;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.olap.api.ICubeCursor;
import org.eclipse.birt.data.engine.olap.api.ICubeQueryResults;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IDimensionDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IHierarchyDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.data.engine.olap.data.api.CubeQueryExecutorHelper;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IBindingValueFetcher;
import org.eclipse.birt.data.engine.olap.data.api.cube.DocManagerMap;
import org.eclipse.birt.data.engine.olap.data.api.cube.ICube;
import org.eclipse.birt.data.engine.olap.data.document.CubeRADocumentManagerFactory;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentManager;
import org.eclipse.birt.data.engine.olap.data.impl.NamingUtil;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.BindingValueFetcher;
import org.eclipse.birt.data.engine.olap.impl.query.CubeCursorImpl;
import org.eclipse.birt.data.engine.olap.impl.query.CubeQueryExecutor;
import org.eclipse.birt.data.engine.olap.impl.query.PreparedCubeQuery;
import org.eclipse.birt.data.engine.olap.impl.query.PreparedCubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.query.view.BirtCubeView;
import org.eclipse.birt.data.engine.olap.script.JSLevelAccessor;
import org.eclipse.birt.data.engine.olap.script.JSMeasureAccessor;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionUtil;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CubeQueryResults
implements ICubeQueryResults {
    protected ICubeQueryDefinition cubeQueryDefinition;
    private Scriptable scope;
    protected DataEngineContext context;
    protected DataEngineSession session;
    private String queryResultsId;
    protected Map appContext;
    private StopSign stopSign;
    private IBaseQueryResults outResults;
    protected ICubeCursor cubeCursor;
    private String name;
    private PreparedCubeQuery preparedQuery;
    protected static Logger logger = Logger.getLogger(CubeQueryResults.class.getName());

    public CubeQueryResults(IBaseQueryResults outResults, PreparedCubeQuery preparedQuery, DataEngineSession session, Scriptable scope, DataEngineContext context, Map appContext) {
        this.cubeQueryDefinition = (ICubeQueryDefinition)preparedQuery.getCubeQueryDefinition();
        this.preparedQuery = preparedQuery;
        this.scope = scope;
        this.context = context;
        this.session = session;
        this.appContext = appContext;
        this.queryResultsId = this.cubeQueryDefinition.getQueryResultsID();
        this.outResults = outResults;
        this.stopSign = session.getStopSign();
    }

    @Override
    public ICubeCursor getCubeCursor() throws DataException {
        if (this.cubeCursor != null) {
            return this.cubeCursor;
        }
        try {
            IBaseExpression expr;
            if (this.session.getEngineContext().getMode() == 2) {
                this.cubeCursor = this.createCursor(null);
                return this.cubeCursor;
            }
            this.stopSign.start();
            HashSet<String> involvedDerivedMeasure = new HashSet<String>();
            Set<String> derivedMeasureNames = OlapExpressionUtil.getDerivedMeasureNames(this.cubeQueryDefinition.getBindings());
            ArrayList<IBinding> bindingSet = new ArrayList<IBinding>();
            bindingSet.addAll(this.cubeQueryDefinition.getBindings());
            if (this.cubeQueryDefinition instanceof PreparedCubeQueryDefinition) {
                Set<IBinding> binding4NestedAggr = ((PreparedCubeQueryDefinition)this.cubeQueryDefinition).getBindingsForNestAggregation();
                for (IBinding binding : binding4NestedAggr) {
                    derivedMeasureNames.add(binding.getBindingName());
                }
                bindingSet.addAll(binding4NestedAggr);
            }
            ArrayList<IFilterDefinition> derivedMeasureFilters = new ArrayList<IFilterDefinition>();
            if (!this.cubeQueryDefinition.getFilters().isEmpty()) {
                for (IFilterDefinition filter : this.cubeQueryDefinition.getFilters()) {
                    expr = filter.getExpression();
                    Set<String> temp = this.getInvolvedDerivedMeasure(expr, derivedMeasureNames, this.cubeQueryDefinition.getBindings());
                    if (temp.size() > 0) {
                        derivedMeasureFilters.add(filter);
                    }
                    involvedDerivedMeasure.addAll(temp);
                }
            }
            if (!this.cubeQueryDefinition.getSorts().isEmpty()) {
                for (ISortDefinition sort : this.cubeQueryDefinition.getSorts()) {
                    expr = sort.getExpression();
                    involvedDerivedMeasure.addAll(this.getInvolvedDerivedMeasure(expr, derivedMeasureNames, this.cubeQueryDefinition.getBindings()));
                }
            }
            if (involvedDerivedMeasure.isEmpty()) {
                this.cubeCursor = this.createCursor(null);
            } else {
                ArrayList<String> candidateBindingOfInteresting = new ArrayList<String>();
                candidateBindingOfInteresting.addAll(involvedDerivedMeasure);
                ArrayList<Set<String>> bindingDimLevels = new ArrayList<Set<String>>();
                for (String bindingName : candidateBindingOfInteresting) {
                    Set<IDimLevel> dimLevels = OlapExpressionUtil.getAggregateOnLevel(bindingName, bindingSet, this.getMeasureDimLevel());
                    HashSet<String> temp = new HashSet<String>();
                    for (IDimLevel dl : dimLevels) {
                        temp.add(OlapExpressionUtil.getAttrReference(dl.getDimensionName(), dl.getLevelName(), dl.getLevelName()));
                    }
                    bindingDimLevels.add(temp);
                }
                ArrayList filterTemp = new ArrayList();
                ArrayList sortTemp = new ArrayList();
                filterTemp.addAll(this.cubeQueryDefinition.getFilters());
                sortTemp.addAll(this.cubeQueryDefinition.getSorts());
                this.cubeQueryDefinition.getFilters().removeAll(derivedMeasureFilters);
                this.cubeQueryDefinition.getSorts().clear();
                this.cubeCursor = this.createCursor(null);
                this.cubeQueryDefinition.getFilters().clear();
                this.cubeQueryDefinition.getFilters().addAll(filterTemp);
                this.cubeQueryDefinition.getSorts().addAll(sortTemp);
                BindingValueFetcher fetcher = new BindingValueFetcher(this.cubeCursor, this.cubeQueryDefinition, candidateBindingOfInteresting, bindingDimLevels);
                this.cubeCursor = this.createCursor(fetcher);
            }
            return this.cubeCursor;
        }
        catch (OLAPException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
        catch (DataException e) {
            if (e.getErrorCode() == "data.olap.FailLoadCube") {
                logger.log(Level.SEVERE, e.getMessage(), e);
                return null;
            }
            throw e;
        }
    }

    private Set<IDimLevel> getMeasureDimLevel() {
        Set<IDimLevel> result = this.getDimLevels(2);
        result.addAll(this.getDimLevels(1));
        return result;
    }

    private Set<IDimLevel> getDimLevels(int edge) {
        HashSet<IDimLevel> result = new HashSet<IDimLevel>();
        IEdgeDefinition edgeDefn = this.cubeQueryDefinition.getEdge(edge);
        if (edgeDefn != null) {
            List<IDimensionDefinition> dimDefns = edgeDefn.getDimensions();
            for (IDimensionDefinition dim : dimDefns) {
                List<IHierarchyDefinition> hier = dim.getHierarchy();
                if (hier.size() != 1) continue;
                List<ILevelDefinition> levels = dim.getHierarchy().get(0).getLevels();
                for (ILevelDefinition level : levels) {
                    result.add(new DimLevel(dim.getName(), level.getName()));
                }
            }
        }
        return result;
    }

    private Set<String> getInvolvedDerivedMeasure(IBaseExpression expr, Set<String> derivedMeasureNames, List<IBinding> bindings) throws DataException {
        HashSet<String> result = new HashSet<String>();
        if (!OlapExpressionUtil.isDirectRerenrence(expr, bindings)) {
            List involvedMeasureNames = ExpressionCompilerUtil.extractColumnExpression(expr, "data");
            for (String candidate : involvedMeasureNames) {
                if (!derivedMeasureNames.contains(candidate)) continue;
                result.add(candidate);
            }
        }
        return result;
    }

    private ICubeCursor createCursor(IBindingValueFetcher fetcher) throws DataException, IOException, OLAPException {
        String newResultSetId;
        CubeQueryExecutor executor = new CubeQueryExecutor(this.outResults, this.cubeQueryDefinition, this.session, this.scope, this.context);
        executor.getdimensionSimpleFilter().addAll(this.preparedQuery.getInternalFilters());
        IDocumentManager documentManager = this.getDocumentManager(executor);
        ICube cube = null;
        try {
            if (!CubeQueryResults.isStandAloneQuery(this.cubeQueryDefinition, this.session.getEngineContext())) {
                cube = this.loadCube(documentManager, executor);
            }
        }
        catch (Exception ex) {
            throw new DataException("data.olap.FailLoadCube", ex);
        }
        BirtCubeView bcv = new BirtCubeView(executor, cube, this.appContext, fetcher);
        CubeCursor cubeCursor = bcv.getCubeCursor(this.stopSign, cube);
        if (cube != null) {
            cube.close();
        }
        if ((newResultSetId = executor.getQueryResultsId()) != null) {
            this.queryResultsId = newResultSetId;
        }
        this.scope.put("measure", this.scope, (Object)new JSMeasureAccessor(cubeCursor, bcv.getMeasureMapping()));
        this.scope.put("dimension", this.scope, (Object)new JSLevelAccessor(this.cubeQueryDefinition, bcv));
        CubeCursorImpl cursor = new CubeCursorImpl(this.outResults, cubeCursor, this.scope, this.session.getEngineContext().getScriptContext(), this.cubeQueryDefinition, bcv);
        return cursor;
    }

    private IDocumentManager getDocumentManager(CubeQueryExecutor executor) throws DataException, IOException {
        IDocumentManager manager = null;
        if (this.preparedQuery.isFromDataMart()) {
            return CubeRADocumentManagerFactory.createRADocumentManager(executor.getCubeQueryDefinition().getName(), executor.getContext().getDocReader());
        }
        if (executor.getContext().getMode() == 3 || executor.getContext().getMode() == 1) {
            manager = DocManagerMap.getDocManagerMap().get(String.valueOf(executor.getSession().getEngine().hashCode()), String.valueOf(executor.getSession().getTempDir()) + executor.getSession().getEngine().hashCode());
        }
        if (manager != null && manager.exist(NamingUtil.getCubeDocName(executor.getCubeQueryDefinition().getName()))) {
            return manager;
        }
        return CubeRADocumentManagerFactory.createRADocumentManager(executor.getCubeQueryDefinition().getName(), executor.getContext().getDocReader());
    }

    private ICube loadCube(IDocumentManager documentManager, CubeQueryExecutor executor) throws DataException, IOException {
        ICube cube = null;
        cube = this.preparedQuery.getInaccessibleDimLevels() == null ? CubeQueryExecutorHelper.loadCube(executor.getCubeQueryDefinition().getName(), documentManager, executor.getSession()) : CubeQueryExecutorHelper.loadCube(executor.getCubeQueryDefinition().getName(), documentManager, executor.getSession().getStopSign(), this.preparedQuery.getInaccessibleDimLevels());
        return cube;
    }

    private static boolean isStandAloneQuery(ICubeQueryDefinition cubeQuery, DataEngineContext context) {
        if (cubeQuery.getQueryResultsID() != null && context.getMode() == 2) {
            List filters = cubeQuery.getFilters();
            if (filters != null && filters.size() > 0) {
                int i = 0;
                while (i < filters.size()) {
                    IFilterDefinition def = (IFilterDefinition)filters.get(i);
                    if (!def.updateAggregation()) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public String getID() {
        return this.queryResultsId;
    }

    @Override
    public void close() throws BirtException {
    }

    @Override
    public void cancel() {
        this.stopSign.stop();
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

