/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document.stream;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.document.stream.StreamID;
import org.eclipse.birt.data.engine.impl.document.stream.StreamReader;
import org.eclipse.birt.data.engine.impl.document.stream.WrapperedRAInputStream;

public class MetaStreamReader
extends StreamReader {
    public MetaStreamReader(DataEngineContext context, StreamID id) throws DataException {
        try {
            this.streamMap = new HashMap();
            this.id = id;
            this.context = context;
            RAInputStream is = context.getInputStream(id.getStartStream(), id.getSubQueryStream(), 100);
            DataInputStream metaIndexStream = new DataInputStream(is);
            while (is.getOffset() != is.length()) {
                int type = IOUtil.readInt(metaIndexStream);
                long offset = IOUtil.readLong(metaIndexStream);
                int size = IOUtil.readInt(metaIndexStream);
                this.streamMap.put(type, new OffsetInfo(offset, size));
            }
            metaIndexStream.close();
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage());
        }
    }

    public RAInputStream getRAInputStream(int streamType) throws DataException {
        Object temp = this.streamMap.get(streamType);
        if (temp == null) {
            throw new DataException("data.engine.document.error.cannotLoadStream", DataEngineContext.getPath(this.id.getStartStream(), this.id.getSubQueryStream(), streamType));
        }
        OffsetInfo oi = (OffsetInfo)temp;
        long offset = oi.offset;
        int size = oi.size;
        WrapperedRAInputStream metaStream = new WrapperedRAInputStream(this.context.getInputStream(this.id.getStartStream(), this.id.getSubQueryStream(), this.getCollectionStreamType()), offset, size);
        return metaStream;
    }

    protected int getCollectionStreamType() {
        return 99;
    }

    private static class OffsetInfo {
        private long offset;
        private int size;

        public OffsetInfo(long offset, int size) {
            this.offset = offset;
            this.size = size;
        }
    }
}

