/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.impl;

import java.util.ArrayList;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.aggregation.calculator.CalculatorFactory;
import org.eclipse.birt.data.aggregation.i18n.Messages;
import org.eclipse.birt.data.aggregation.impl.AggrException;
import org.eclipse.birt.data.aggregation.impl.AggrFunction;
import org.eclipse.birt.data.aggregation.impl.Constants;
import org.eclipse.birt.data.aggregation.impl.Finance;
import org.eclipse.birt.data.aggregation.impl.ParameterDefn;
import org.eclipse.birt.data.aggregation.impl.SummaryAccumulator;
import org.eclipse.birt.data.aggregation.impl.SupportedDataTypes;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.data.engine.core.DataException;

public class TotalIrr
extends AggrFunction {
    public String getName() {
        return "IRR";
    }

    public int getType() {
        return 0;
    }

    public int getDataType() {
        return 3;
    }

    public IParameterDefn[] getParameterDefn() {
        return new IParameterDefn[]{new ParameterDefn("Expression", Constants.EXPRESSION_DISPLAY_NAME, false, true, SupportedDataTypes.CALCULATABLE, ""), new ParameterDefn("intrate", Messages.getString("TotalIrr.param.intrate"), false, false, SupportedDataTypes.CALCULATABLE, "")};
    }

    public Accumulator newAccumulator() {
        return new MyAccumulator();
    }

    public String getDescription() {
        return Messages.getString("TotalIrr.description");
    }

    public String getDisplayName() {
        return Messages.getString("TotalIrr.displayName");
    }

    private static class MyAccumulator
    extends SummaryAccumulator {
        private ArrayList<Number> list;
        private double intrate = 0.0;
        private Number ret = null;

        private MyAccumulator() {
        }

        public void start() {
            super.start();
            this.intrate = 0.0;
            this.list = new ArrayList();
            this.ret = null;
        }

        public void onRow(Object[] args) throws DataException {
            assert (args.length > 1);
            if (args[0] != null && args[1] != null) {
                if (this.calculator == null) {
                    this.calculator = CalculatorFactory.getCalculator(args[0].getClass());
                }
                try {
                    if (this.list.size() == 0) {
                        this.intrate = DataTypeUtil.toDouble(args[1]);
                    }
                    this.list.add(this.calculator.add(0, args[0]));
                }
                catch (BirtException e) {
                    throw DataException.wrap(new AggrException("aggregation.DataConversionError", e));
                }
            }
        }

        public void finish() throws DataException {
            if (this.list.size() > 0) {
                Object[] values = new Number[this.list.size()];
                this.list.toArray(values);
                try {
                    this.ret = new Double(Finance.irr(values, this.intrate));
                }
                catch (BirtException e) {
                    throw DataException.wrap(e);
                }
            }
            super.finish();
        }

        public Object getSummaryValue() {
            return this.ret;
        }
    }
}

