/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.validators.ValidationEvent;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.SemanticTriggerDefn;
import org.eclipse.birt.report.model.validators.AbstractElementValidator;
import org.eclipse.birt.report.model.validators.AbstractPropertyValidator;
import org.eclipse.birt.report.model.validators.AbstractSemanticValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationNode {
    protected DesignElement element;
    protected SemanticTriggerDefn triggerDefn = null;

    ValidationNode(DesignElement element, SemanticTriggerDefn triggerDefn) {
        assert (element != null);
        assert (triggerDefn != null);
        this.element = element;
        this.triggerDefn = triggerDefn;
    }

    DesignElement getElement() {
        return this.element;
    }

    final List<SemanticException> perform(Module module, boolean sendEvent) {
        AbstractSemanticValidator validator = this.triggerDefn.getValidator();
        if (module instanceof ReportDesign && !validator.canApplyToDesign() || module instanceof Library && !validator.canApplyToLibrary()) {
            return Collections.emptyList();
        }
        DesignElement toValidate = this.element;
        String elementName = this.triggerDefn.getTargetElement();
        if (!StringUtil.isBlank(elementName)) {
            ElementDefn targetDefn = (ElementDefn)MetaDataDictionary.getInstance().getElement(elementName);
            while (toValidate != null) {
                ElementDefn elementDefn = (ElementDefn)toValidate.getDefn();
                if (elementDefn.isKindOf(targetDefn)) break;
                toValidate = toValidate.getContainer();
            }
        }
        if (toValidate == null) {
            return Collections.emptyList();
        }
        List<SemanticException> errors = null;
        if (validator instanceof AbstractPropertyValidator) {
            errors = ((AbstractPropertyValidator)validator).validate(module, toValidate, this.triggerDefn.getPropertyName());
        } else if (validator instanceof AbstractElementValidator) {
            errors = ((AbstractElementValidator)validator).validate(module, toValidate);
        }
        assert (errors != null);
        if (!sendEvent) {
            return errors;
        }
        ArrayList<ErrorDetail> errorDetailList = new ArrayList<ErrorDetail>();
        for (SemanticException e : errors) {
            ErrorDetail errorDetail = new ErrorDetail(e);
            errorDetail.setValidationID(this.triggerDefn.getValidationID());
            errorDetailList.add(errorDetail);
        }
        ValidationEvent event = new ValidationEvent(toValidate, this.triggerDefn.getValidationID(), errorDetailList);
        module.broadcastValidationEvent(toValidate, event);
        return errors;
    }

    SemanticTriggerDefn getTriggerDefn() {
        return this.triggerDefn;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("element=");
        sb.append(this.element.getElementName());
        sb.append(", ");
        sb.append("name=");
        sb.append(this.element.getFullName());
        sb.append(", ");
        sb.append("id=");
        sb.append(this.element.toString());
        sb.append(", ");
        sb.append("validator=");
        sb.append(this.triggerDefn.getValidatorName());
        return sb.toString();
    }
}

