/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IDesignElement;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.util.IElementCopy;
import org.eclipse.birt.report.model.api.util.IPasteStatus;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.util.ContentExceptionFactory;
import org.eclipse.birt.report.model.util.LevelContentIterator;
import org.eclipse.birt.report.model.util.copy.ContextCopyPastePolicy;
import org.eclipse.birt.report.model.util.copy.PasteStatus;

public class CopyUtil {
    private static ContextCopyPastePolicy copyPastePolicy = new ContextCopyPastePolicy();

    public static IElementCopy copy(DesignElementHandle source) {
        return copyPastePolicy.createCopy(source.getElement(), source.getModule());
    }

    public static List paste(IElementCopy copy, DesignElementHandle container, int slotID) throws SemanticException {
        ContainerContext context = new ContainerContext(container.getElement(), slotID);
        Module root = container.getModule();
        if (!CopyUtil.canPaste(copy, container, slotID).canPaste()) {
            throw ContentExceptionFactory.createContentException(context, "Error.ContentException.CONTENT_NOT_ALLOWED_PASTED");
        }
        IDesignElement chosen = copyPastePolicy.preWorkForPaste(context, copy, root);
        if (chosen == null) {
            return Collections.EMPTY_LIST;
        }
        DesignElementHandle target = chosen.getHandle(root);
        container.getModuleHandle().rename(container, target);
        container.getSlot(slotID).add(target);
        copyPastePolicy.copyPropertyBindings(copy, target);
        return CopyUtil.checkPostPasteErrors(target.getElement(), root);
    }

    public static List paste(IElementCopy copy, DesignElementHandle container, int slotID, int newPos) throws SemanticException {
        ContainerContext context = new ContainerContext(container.getElement(), slotID);
        Module root = container.getModule();
        if (!CopyUtil.canPaste(copy, container, slotID).canPaste()) {
            throw ContentExceptionFactory.createContentException(context, "Error.ContentException.CONTENT_NOT_ALLOWED_PASTED");
        }
        IDesignElement chosen = copyPastePolicy.preWorkForPaste(context, copy, root);
        if (chosen == null) {
            return Collections.EMPTY_LIST;
        }
        DesignElementHandle target = chosen.getHandle(root);
        container.getModuleHandle().rename(container, target);
        container.getSlot(slotID).add(target, newPos);
        copyPastePolicy.copyPropertyBindings(copy, target);
        return CopyUtil.checkPostPasteErrors(target.getElement(), root);
    }

    public static List paste(IElementCopy copy, DesignElementHandle container, String propName) throws SemanticException {
        ContainerContext context = new ContainerContext(container.getElement(), propName);
        Module root = container.getModule();
        if (!CopyUtil.canPaste(copy, container, propName).canPaste()) {
            throw ContentExceptionFactory.createContentException(context, "Error.ContentException.CONTENT_NOT_ALLOWED_PASTED");
        }
        IDesignElement chosen = copyPastePolicy.preWorkForPaste(context, copy, root);
        if (chosen == null) {
            return Collections.EMPTY_LIST;
        }
        DesignElementHandle target = chosen.getHandle(root);
        container.getModuleHandle().rename(container, target);
        container.add(propName, target);
        copyPastePolicy.copyPropertyBindings(copy, target);
        return CopyUtil.checkPostPasteErrors(target.getElement(), root);
    }

    public static List paste(IElementCopy copy, DesignElementHandle container, String propName, int newPos) throws SemanticException {
        ContainerContext context = new ContainerContext(container.getElement(), propName);
        Module root = container.getModule();
        if (!CopyUtil.canPaste(copy, container, propName).canPaste()) {
            throw ContentExceptionFactory.createContentException(context, "Error.ContentException.CONTENT_NOT_ALLOWED_PASTED");
        }
        IDesignElement chosen = copyPastePolicy.preWorkForPaste(context, copy, root);
        if (chosen == null) {
            return Collections.EMPTY_LIST;
        }
        DesignElementHandle target = chosen.getHandle(root);
        container.getModuleHandle().rename(container, target);
        container.add(propName, target, newPos);
        copyPastePolicy.copyPropertyBindings(copy, target);
        return CopyUtil.checkPostPasteErrors(target.getElement(), root);
    }

    public static IPasteStatus canPaste(IElementCopy copy, DesignElementHandle container, int slotID) {
        int tmpIndex = container.getElement().getSlotIndex(slotID);
        if (tmpIndex == -1) {
            PasteStatus status = new PasteStatus();
            status.setPaste(false);
            return status;
        }
        return copyPastePolicy.isValidCopy(new ContainerContext(container.getElement(), slotID), container.getModule(), copy);
    }

    public static IPasteStatus canPaste(IElementCopy copy, DesignElementHandle container, String propName) {
        ElementPropertyDefn propDefn = (ElementPropertyDefn)container.getPropertyDefn(propName);
        if (propDefn == null || !propDefn.isElementType()) {
            PasteStatus status = new PasteStatus();
            status.setPaste(false);
            return status;
        }
        return copyPastePolicy.isValidCopy(new ContainerContext(container.getElement(), propName), container.getModule(), copy);
    }

    private static List checkPostPasteErrors(DesignElement content, Module root) {
        CopyUtil.revisePropertyNameSpace(root, content, content.getDefn().getProperty("extends"));
        CopyUtil.reviseNameSpace(root, content);
        List<Exception> exceptionList = content.validateWithContents(root);
        List<ErrorDetail> errorDetailList = ErrorDetail.convertExceptionList(exceptionList);
        return errorDetailList;
    }

    private static void reviseNameSpace(Module module, DesignElement content) {
        Iterator<String> propNames = content.propertyWithLocalValueIterator();
        IElementDefn defn = content.getDefn();
        while (propNames.hasNext()) {
            String propName = propNames.next();
            ElementPropertyDefn propDefn = (ElementPropertyDefn)defn.getProperty(propName);
            CopyUtil.revisePropertyNameSpace(module, content, propDefn);
        }
        LevelContentIterator iter = new LevelContentIterator(module, content, 1);
        while (iter.hasNext()) {
            DesignElement item = (DesignElement)iter.next();
            CopyUtil.reviseNameSpace(module, item);
        }
    }

    private static void revisePropertyNameSpace(Module module, DesignElement content, IElementPropertyDefn propDefn) {
        if (propDefn == null || content == null) {
            return;
        }
        if (propDefn.getTypeCode() != 15 && propDefn.getTypeCode() != 17) {
            return;
        }
        content.getLocalProperty(module, (ElementPropertyDefn)propDefn);
    }
}

