/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.re;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.report.engine.extension.ReportItemQueryBase;
import org.eclipse.birt.report.item.crosstab.core.CrosstabException;
import org.eclipse.birt.report.item.crosstab.core.ICrosstabConstants;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.core.re.CrosstabQueryUtil;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;

public class CrosstabReportItemQuery
extends ReportItemQueryBase
implements ICrosstabConstants {
    private static Logger logger = Logger.getLogger(CrosstabReportItemQuery.class.getName());
    private CrosstabReportItemHandle crosstabItem;

    public void setModelObject(ExtendedItemHandle modelHandle) {
        super.setModelObject(modelHandle);
        try {
            this.crosstabItem = (CrosstabReportItemHandle)modelHandle.getReportItem();
        }
        catch (ExtendedElementException extendedElementException) {
            logger.log(Level.SEVERE, Messages.getString("CrosstabReportItemQuery.error.crosstab.loading"));
            this.crosstabItem = null;
        }
    }

    public IDataQueryDefinition[] createReportQueries(IDataQueryDefinition parent) throws BirtException {
        if (this.crosstabItem == null) {
            throw new CrosstabException(Messages.getString("CrosstabReportItemQuery.error.query.building"));
        }
        ICubeQueryDefinition cubeQuery = CrosstabQueryUtil.createCubeQuery(this.crosstabItem, parent, this.context.getDataRequestSession().getModelAdaptor(), true, true, true, true, true, true);
        if (this.context != null) {
            LevelViewHandle lv;
            DimensionViewHandle dv;
            int j;
            this.processChildQuery(cubeQuery, this.crosstabItem.getHeader());
            int i = 0;
            while (i < this.crosstabItem.getMeasureCount()) {
                MeasureViewHandle mv = this.crosstabItem.getMeasure(i);
                this.processChildQuery(cubeQuery, mv.getCell());
                j = 0;
                while (j < mv.getHeaderCount()) {
                    this.processChildQuery(cubeQuery, mv.getHeader(j));
                    ++j;
                }
                j = 0;
                while (j < mv.getAggregationCount()) {
                    this.processChildQuery(cubeQuery, mv.getAggregationCell(j));
                    ++j;
                }
                ++i;
            }
            if (this.crosstabItem.getDimensionCount(0) > 0) {
                i = 0;
                while (i < this.crosstabItem.getDimensionCount(0)) {
                    dv = this.crosstabItem.getDimension(0, i);
                    j = 0;
                    while (j < dv.getLevelCount()) {
                        lv = dv.getLevel(j);
                        this.processChildQuery(cubeQuery, lv.getCell());
                        this.processChildQuery(cubeQuery, lv.getAggregationHeader());
                        ++j;
                    }
                    ++i;
                }
            }
            if (this.crosstabItem.getDimensionCount(1) > 0) {
                i = 0;
                while (i < this.crosstabItem.getDimensionCount(1)) {
                    dv = this.crosstabItem.getDimension(1, i);
                    j = 0;
                    while (j < dv.getLevelCount()) {
                        lv = dv.getLevel(j);
                        this.processChildQuery(cubeQuery, lv.getCell());
                        this.processChildQuery(cubeQuery, lv.getAggregationHeader());
                        ++j;
                    }
                    ++i;
                }
            }
            this.processChildQuery(cubeQuery, this.crosstabItem.getGrandTotal(0));
            this.processChildQuery(cubeQuery, this.crosstabItem.getGrandTotal(1));
        }
        return new IDataQueryDefinition[]{cubeQuery};
    }

    private void processChildQuery(IDataQueryDefinition parent, CrosstabCellHandle cell) {
        if (cell != null) {
            for (ReportElementHandle handle : cell.getContents()) {
                this.context.createQuery(parent, handle);
            }
        }
    }
}

