/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.util.Iterator;
import java.util.logging.Level;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBasePreparedQuery;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.engine.adapter.ModelDteApiAdapter;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IDatasetPreviewTask;
import org.eclipse.birt.report.engine.api.IExtractionResults;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IResultMetaData;
import org.eclipse.birt.report.engine.api.IRunnable;
import org.eclipse.birt.report.engine.api.impl.EngineTask;
import org.eclipse.birt.report.engine.api.impl.ExtractionResults;
import org.eclipse.birt.report.engine.api.impl.ParameterValidationException;
import org.eclipse.birt.report.engine.api.impl.ReportEngine;
import org.eclipse.birt.report.engine.api.impl.ReportRunnable;
import org.eclipse.birt.report.engine.api.impl.ResultMetaData;
import org.eclipse.birt.report.engine.script.internal.ReportScriptExecutor;
import org.eclipse.birt.report.model.api.AbstractScalarParameterHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

public class DatasetPreviewTask
extends EngineTask
implements IDatasetPreviewTask {
    protected IRunnable runnable;
    protected DataSetHandle dataset;
    protected int maxRow;

    protected DatasetPreviewTask(ReportEngine engine) {
        super(engine, 5);
    }

    public IExtractionResults execute() throws EngineException {
        if (this.dataset == null) {
            throw new IllegalArgumentException("dataset can not be null");
        }
        return this.runDataset();
    }

    public void setMaxRow(int maxRow) {
        this.maxRow = maxRow;
    }

    protected void checkRequiredParamenter(String paramName, String value) throws ParameterValidationException {
    }

    public void setDataSet(DataSetHandle dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("dataset can not be null!");
        }
        this.dataset = dataset;
        ModuleHandle mh = dataset.getModuleHandle();
        this.runnable = new ReportRunnable((IReportEngine)this.engine, mh);
        this.setReportRunnable((ReportRunnable)this.runnable);
    }

    public void setRunnable(IRunnable runnable) {
        this.runnable = runnable;
        this.setReportRunnable((ReportRunnable)runnable);
    }

    protected ModuleHandle getHandle() {
        return ((ReportRunnable)this.runnable).getModuleHandle();
    }

    protected IExtractionResults runDataset() throws EngineException {
        IExtractionResults resultset = null;
        try {
            this.switchToOsgiClassLoader();
            this.changeStatusToRunning();
            if (this.runnable == null) {
                throw new EngineException("Error.ReportRunnableNotSet");
            }
            resultset = this.doRun();
        }
        finally {
            this.changeStatusToStopped();
            this.switchClassLoaderBack();
        }
        return resultset;
    }

    protected IExtractionResults doRun() throws EngineException {
        IExtractionResults result = null;
        this.usingParameterValues();
        this.initReportVariable();
        this.loadDesign();
        this.prepareDesign();
        this.startFactory();
        try {
            try {
                this.executionContext.openDataEngine();
                result = this.extractQuery(this.dataset);
            }
            catch (Exception ex) {
                this.log.log(Level.SEVERE, "An error happened while extracting data the report. Cause:", ex);
                throw new EngineException("Error.ReportRunError", ex);
            }
            catch (OutOfMemoryError err) {
                this.log.log(Level.SEVERE, "There is insufficient memory to extract data from this report.");
                throw err;
            }
            catch (Throwable t) {
                this.log.log(Level.SEVERE, "Error happened while running the report.", t);
                throw new EngineException("Error.ReportRunError", t);
            }
        }
        finally {
            this.closeFactory();
        }
        return result;
    }

    protected IExtractionResults extractQuery(DataSetHandle dataset) throws BirtException {
        QueryDefinition newQuery = this.constructQuery(dataset);
        DataRequestSession session = this.executionContext.getDataEngine().getDTESession();
        ModelDteApiAdapter apiAdapter = new ModelDteApiAdapter(this.executionContext);
        apiAdapter.defineDataSet(dataset, session);
        session.registerQueries(new IQueryDefinition[]{newQuery});
        IPreparedQuery preparedQuery = session.prepare(newQuery);
        IQueryResults result = (IQueryResults)session.execute((IBasePreparedQuery)preparedQuery, null, this.executionContext.getScriptContext());
        ResultMetaData metadata = new ResultMetaData(result.getResultMetaData());
        return new ExtractionResults(result, (IResultMetaData)metadata, null, 0, this.maxRow);
    }

    protected ModuleHandle getModuleHandle() {
        return this.dataset.getModuleHandle();
    }

    protected QueryDefinition constructQuery(DataSetHandle dataset) throws DataException {
        QueryDefinition query = new QueryDefinition();
        query.setDataSetName(dataset.getQualifiedName());
        query.setAutoBinding(true);
        if (this.maxRow > 0) {
            query.setMaxRows(this.maxRow);
        }
        return query;
    }

    protected void validateStringParameter(String paramName, Object paramValue, AbstractScalarParameterHandle paramHandle) throws ParameterValidationException {
    }

    protected void loadDesign() {
        ReportRunnable runnable = this.executionContext.getRunnable();
        if (runnable != null) {
            ReportDesignHandle reportDesign = this.executionContext.getReportDesign();
            if (reportDesign != null) {
                Iterator iter = reportDesign.includeLibraryScriptsIterator();
                this.loadScript(iter);
                iter = reportDesign.includeScriptsIterator();
                this.loadScript(iter);
                ReportScriptExecutor.handleInitialize(reportDesign, this.executionContext);
            } else if (this.dataset != null) {
                ModuleHandle moduleHandle = this.dataset.getModuleHandle();
                Iterator iter = moduleHandle.includeScriptsIterator();
                this.loadScript(iter);
                ReportScriptExecutor.handleInitialize(moduleHandle, this.executionContext);
            }
        }
    }
}

