/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.birt.report.data.oda.jdbc.DBConfig;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

class SaxParser
extends DefaultHandler {
    private static final String TYPE = "type";
    private static final String POLICY = "Policy";
    private static final String NAME = "name";
    private static final String DRIVER = "Driver";
    private int currentPolicy = -1;
    private DBConfig dbConfig;

    public SaxParser(DBConfig config) {
        this.dbConfig = config;
    }

    public void startElement(String uri, String name, String qName, Attributes atts) {
        String elementName = qName;
        if (elementName.equals(DRIVER)) {
            this.dbConfig.putPolicy(atts.getValue(NAME), this.currentPolicy);
        } else if (elementName.equals(POLICY)) {
            String type = atts.getValue(TYPE);
            try {
                this.currentPolicy = Integer.parseInt(type);
            }
            catch (NumberFormatException numberFormatException) {
                this.currentPolicy = -1;
            }
        }
    }

    public void parse() {
        try {
            if (this.dbConfig.getConfigURL() == null) {
                return;
            }
            Object xmlReader = this.createXMLReader();
            this.setContentHandler(xmlReader);
            this.setErrorHandler(xmlReader);
            this.parse(xmlReader);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void parse(Object xmlReader) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method parse = this.getMethod("parse", xmlReader.getClass(), new Class[]{InputSource.class});
        try {
            BufferedInputStream is = new BufferedInputStream(this.dbConfig.getConfigURL().openStream());
            InputSource source = new InputSource(is);
            source.setEncoding(source.getEncoding());
            parse.invoke(xmlReader, source);
            ((InputStream)is).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void setErrorHandler(Object xmlReader) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method setErrorHandler = this.getMethod("setErrorHandler", xmlReader.getClass(), new Class[]{ErrorHandler.class});
        this.invokeMethod(setErrorHandler, xmlReader, new Object[]{this});
    }

    private void setContentHandler(Object xmlReader) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method setContentHandler = this.getMethod("setContentHandler", xmlReader.getClass(), new Class[]{ContentHandler.class});
        this.invokeMethod(setContentHandler, xmlReader, new Object[]{this});
    }

    private Object createXMLReader() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        try {
            Object xmlReader = Thread.currentThread().getContextClassLoader().loadClass("org.apache.xerces.parsers.SAXParser").newInstance();
            return xmlReader;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Class.forName("org.apache.xerces.parsers.SAXParser").newInstance();
        }
    }

    private Method getMethod(String methodName, Class targetClass, Class[] argument) throws SecurityException, NoSuchMethodException {
        assert (methodName != null);
        assert (targetClass != null);
        assert (argument != null);
        return targetClass.getMethod(methodName, argument);
    }

    private void invokeMethod(Method method, Object targetObject, Object[] argument) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        method.invoke(targetObject, argument);
    }
}

