/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.group;

import java.math.BigDecimal;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.impl.group.GroupCalculator;

public class DecimalGroupCalculator
extends GroupCalculator {
    BigDecimal doubleStartValue;

    public DecimalGroupCalculator(Object intervalStart, double intervalRange) throws BirtException {
        super(intervalStart, intervalRange);
        this.intervalRange = intervalRange = intervalRange == 0.0 ? 1.0 : intervalRange;
        this.doubleStartValue = intervalStart == null ? new BigDecimal(-1) : DataTypeUtil.toBigDecimal(intervalStart);
    }

    public Object calculate(Object value) throws BirtException {
        if (value == null) {
            return new BigDecimal(-1);
        }
        BigDecimal dValue = DataTypeUtil.toBigDecimal(value);
        if (dValue.compareTo(this.doubleStartValue) < 0) {
            return new Double(-1.0);
        }
        dValue = dValue.subtract(this.doubleStartValue);
        dValue = dValue.divide(new BigDecimal(this.intervalRange), 0, 3);
        return dValue;
    }
}

