/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.impl.rank;

import org.eclipse.birt.data.aggregation.impl.RunningAccumulator;
import org.eclipse.birt.data.aggregation.impl.TempDir;
import org.eclipse.birt.data.aggregation.impl.rank.BasicCachedListExt;
import org.eclipse.birt.data.aggregation.impl.rank.RankAggregationUtil;
import org.eclipse.birt.data.engine.cache.BasicCachedArray;
import org.eclipse.birt.data.engine.core.DataException;

public abstract class BaseTopBottomAccumulator
extends RunningAccumulator {
    protected BasicCachedListExt cachedValues;
    private double N;
    private int passNo = 0;
    private BasicCachedArray targetValue;
    private int currentIndex = -1;
    private Object value = null;
    private static Boolean trueValue = Boolean.TRUE;
    private static Boolean falseValue = Boolean.FALSE;
    private String tempDir = TempDir.getInstance().getPath();

    public BaseTopBottomAccumulator() {
        this.targetValue = new BasicCachedArray(this.tempDir, 0);
    }

    public void start() throws DataException {
        super.start();
        ++this.passNo;
        if (this.passNo == 1) {
            this.cachedValues = new BasicCachedListExt(this.tempDir);
            this.N = -1.0;
        } else {
            this.targetValue = this.getTargetValueIndex();
        }
    }

    private BasicCachedArray getTargetValueIndex() throws DataException {
        int n = this.adjustNValue(this.N);
        BasicCachedArray result = new BasicCachedArray(this.tempDir, n < this.cachedValues.size() ? n : this.cachedValues.size());
        int i = 0;
        while (i < n && i < this.cachedValues.size()) {
            int ind = this.getNextIndex();
            if (ind == -1) {
                return result;
            }
            result.set(i, ind);
            ++i;
        }
        this.cachedValues = null;
        return result;
    }

    public Object getValue() throws DataException {
        return this.value;
    }

    public void onRow(Object[] args) throws DataException {
        assert (args.length == 2);
        if (this.passNo == 1) {
            if (args[0] != null) {
                this.cachedValues.add(args[0]);
            } else {
                this.cachedValues.add(RankAggregationUtil.getNullObject());
            }
            if (this.N == -1.0) {
                if (args.length < 2) {
                    throw new DataException("data.engine.InvalidTopBottomNArgument");
                }
                this.N = this.populateNValue(args[1]);
            }
        } else {
            ++this.currentIndex;
            this.value = this.populateValue();
        }
    }

    private Boolean populateValue() {
        int i = 0;
        while (i < this.targetValue.length()) {
            if (this.currentIndex == (Integer)this.targetValue.get(i)) {
                return trueValue;
            }
            ++i;
        }
        return falseValue;
    }

    protected abstract int getNextIndex() throws DataException;

    protected abstract double populateNValue(Object var1) throws DataException;

    protected abstract int adjustNValue(double var1);
}

