/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.plugin;

import org.eclipse.birt.chart.computation.ChartComputationFactory;
import org.eclipse.birt.chart.computation.GObjectFactory;
import org.eclipse.birt.chart.computation.IChartComputationFactory;
import org.eclipse.birt.chart.device.IImageWriterFactory;
import org.eclipse.birt.chart.device.IScriptMenuHelper;
import org.eclipse.birt.chart.device.ImageWriterFactory;
import org.eclipse.birt.chart.device.ScriptMenuHelper;
import org.eclipse.birt.chart.model.IChartModelHelper;
import org.eclipse.birt.chart.model.impl.ChartModelHelper;
import org.eclipse.birt.chart.reportitem.ChartReportItemUtil;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;

public class ChartReportItemPlugin
extends Plugin {
    public static final String ID = "org.eclipse.birt.chart.reportitem";
    private static ChartReportItemPlugin plugin;

    public ChartReportItemPlugin() {
        plugin = this;
    }

    public static ChartReportItemPlugin getDefault() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ChartReportItemPlugin.initChartComputation(this);
        ChartReportItemPlugin.initImageWriterFactory(this);
        ChartReportItemPlugin.initChartModelHelper(this);
        ChartReportItemPlugin.initChartScriptMenuHelper(this);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    private static void initChartScriptMenuHelper(ChartReportItemPlugin plugin) {
        IScriptMenuHelper factory = ChartReportItemUtil.getAdapter((Object)plugin, IScriptMenuHelper.class);
        if (factory != null) {
            ScriptMenuHelper.initInstance(factory);
        }
    }

    private static void initChartComputation(ChartReportItemPlugin plugin) {
        IChartComputationFactory factory = ChartReportItemUtil.getAdapter((Object)plugin, IChartComputationFactory.class);
        if (factory != null) {
            ChartComputationFactory.initInstance(factory);
            GObjectFactory.initInstance(factory.createGObjectFactory());
        }
    }

    private static void initImageWriterFactory(ChartReportItemPlugin plugin) {
        IImageWriterFactory factory = ChartReportItemUtil.getAdapter((Object)plugin, IImageWriterFactory.class);
        if (factory != null) {
            ImageWriterFactory.initInstance(factory);
        }
    }

    private static void initChartModelHelper(ChartReportItemPlugin plugin) {
        IChartModelHelper factory = ChartReportItemUtil.getAdapter((Object)plugin, IChartModelHelper.class);
        if (factory != null) {
            ChartModelHelper.initInstance(factory);
        }
    }
}

