/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.template.TemplateParser;
import org.eclipse.birt.core.template.TextTemplate;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.TextItem;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.ReportItemState;
import org.eclipse.birt.report.model.util.BoundDataColumnUtil;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TextItemState
extends ReportItemState {
    protected TextItem element;

    public TextItemState(ModuleParserHandler handler, DesignElement theContainer, int slot) {
        super(handler, theContainer, slot);
    }

    public TextItemState(ModuleParserHandler handler, DesignElement theContainer, String prop) {
        super(handler, theContainer, prop);
    }

    public void parseAttrs(Attributes attrs) throws XMLParserException {
        this.element = new TextItem();
        this.initElement(attrs);
    }

    public DesignElement getElement() {
        return this.element;
    }

    public void end() throws SAXException {
        String content;
        super.end();
        if (this.handler.versionNumber < 3020100 && !StringUtil.isBlank(content = (String)this.element.getLocalProperty(this.handler.getModule(), "content"))) {
            List jsExprs = BoundDataColumnUtil.getExpressions(content, this.element, this.handler.getModule());
            this.updateExpressions(content, BoundDataColumnUtil.handleJavaExpression(jsExprs, this.element, this.handler.getModule(), this.handler.tempValue));
        }
    }

    private void updateExpressions(String contentText, Map updatedExprs) {
        if (updatedExprs.isEmpty()) {
            return;
        }
        String contentType = (String)this.element.getProperty(this.handler.getModule(), "contentType");
        if (!"auto".equalsIgnoreCase(contentType) && !"html".equalsIgnoreCase(contentType)) {
            return;
        }
        TextTemplate template = new TemplateParser().parse(contentText);
        BoundDataColumnUtil.ContentVisitor templateVisitor = new BoundDataColumnUtil.ContentVisitor(template, updatedExprs);
        String content = templateVisitor.execute();
        this.element.setProperty("content", (Object)content);
    }
}

