/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.strategy.CopyPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleElementSlot
extends ContainerSlot {
    private DesignElement content = null;

    @Override
    public Object doClone(CopyPolicy policy) throws CloneNotSupportedException {
        SingleElementSlot slot = (SingleElementSlot)super.clone();
        if (this.content != null) {
            slot.content = (DesignElement)this.content.doClone(policy);
        }
        return slot;
    }

    @Override
    public int findPosn(DesignElement element) {
        if (element != null && element == this.content) {
            return 0;
        }
        return -1;
    }

    @Override
    public void insert(DesignElement element, int posn) {
        assert (this.content == null);
        assert (element != null);
        assert (posn == 0);
        this.content = element;
    }

    @Override
    public void remove(DesignElement element) {
        assert (this.content != null && this.content == element);
        this.content = null;
    }

    @Override
    public Object remove(int posn) {
        assert (posn == 0);
        this.content = null;
        return null;
    }

    @Override
    public boolean canDrop(DesignElement element) {
        assert (this.content != null && this.content == element);
        return true;
    }

    @Override
    public List<DesignElement> getContents() {
        ArrayList<DesignElement> list = new ArrayList<DesignElement>();
        if (this.content != null) {
            list.add(this.content);
        }
        return list;
    }

    @Override
    public int getCount() {
        return this.content == null ? 0 : 1;
    }

    @Override
    public void moveContent(int from, int to) {
        assert (false);
    }

    @Override
    public boolean contains(DesignElement element) {
        return element != null && this.content == element;
    }

    @Override
    public DesignElement getContent(int pos) {
        assert (pos == 0 && this.content != null);
        return this.content;
    }

    @Override
    public void clear() {
        this.content = null;
    }
}

