/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import org.eclipse.birt.report.model.activity.AbstractElementCommand;
import org.eclipse.birt.report.model.api.AbstractThemeHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.PropertyNameException;
import org.eclipse.birt.report.model.api.command.ThemeException;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.command.ThemeRecord;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.AbstractTheme;
import org.eclipse.birt.report.model.elements.ReportItemTheme;
import org.eclipse.birt.report.model.elements.interfaces.ISupportThemeElement;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.util.ReferenceValueUtil;

public class ThemeCommand
extends AbstractElementCommand {
    public ThemeCommand(Module module, DesignElement element) {
        super(module, element);
        if (element.getPropertyDefn("theme") == null) {
            throw new IllegalArgumentException("The element does not support theme property!");
        }
    }

    public void setTheme(String name) throws SemanticException {
        Object retValue = this.doValidateValue(name);
        this.doSetThemeRefValue((ElementRefValue)retValue);
    }

    public void setThemeElement(AbstractThemeHandle theme) throws SemanticException {
        if (theme == null) {
            this.setTheme(null);
            return;
        }
        String name = null;
        name = ReferenceValueUtil.needTheNamespacePrefix(theme.getElement(), theme.getModule(), this.module);
        Object retValue = this.doValidateValue(name);
        ElementRefValue refValue = (ElementRefValue)retValue;
        if (refValue.isResolved() && refValue.getElement() != theme.getElement()) {
            throw new SemanticError(this.element, new String[]{"theme", refValue.getName()}, "Error.SemanticError.INVALID_ELEMENT_REF");
        }
        this.doSetThemeRefValue((ElementRefValue)retValue);
    }

    protected void setThemeRefValue(ElementRefValue refValue) throws SemanticException {
        if (refValue == null && ((ISupportThemeElement)((Object)this.element)).getThemeName() == null) {
            return;
        }
        this.doSetThemeRefValue(refValue);
    }

    private Object doValidateValue(String name) throws SemanticException {
        name = StringUtil.trimString(name);
        ElementPropertyDefn propDefn = this.element.getPropertyDefn("theme");
        if (propDefn == null) {
            throw new PropertyNameException(this.element, "theme");
        }
        if (name == null && ((ISupportThemeElement)((Object)this.element)).getThemeName() == null) {
            return null;
        }
        return propDefn.validateValue(this.module, this.element, name);
    }

    private void doSetThemeRefValue(ElementRefValue newThemeValue) throws SemanticException {
        if (newThemeValue != null) {
            String name = ReferenceValueUtil.needTheNamespacePrefix(newThemeValue, this.element.getRoot());
            if (!newThemeValue.isResolved()) {
                throw new ThemeException(this.element, name, "Error.ThemeException.NOT_FOUND");
            }
            AbstractTheme theme = (AbstractTheme)newThemeValue.getElement();
            String matchedType = MetaDataDictionary.getInstance().getThemeType(this.element.getDefn());
            if (theme instanceof ReportItemTheme && (matchedType == null || !matchedType.equals(((ReportItemTheme)theme).getType(this.module)))) {
                throw new ThemeException(this.element, name, "Error.ThemeException.WRONG_TYPE");
            }
        }
        if (newThemeValue != null && newThemeValue.isResolved() && newThemeValue.getElement() == ((ISupportThemeElement)((Object)this.element)).getTheme()) {
            return;
        }
        ThemeRecord themeRecord = new ThemeRecord(this.element, newThemeValue);
        this.getModule().getActivityStack().execute(themeRecord);
    }
}

