/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.nLayout.area.impl;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.IBandContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.css.dom.StyleDeclaration;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.ir.GridItemDesign;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.engine.nLayout.LayoutContext;
import org.eclipse.birt.report.engine.nLayout.area.IArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.BlockTextArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.CellArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.DummyCell;
import org.eclipse.birt.report.engine.nLayout.area.impl.FixedLayoutPageHintGenerator;
import org.eclipse.birt.report.engine.nLayout.area.impl.LocalProperties;
import org.eclipse.birt.report.engine.nLayout.area.impl.RepeatableArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.RowArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.TableLayout;
import org.eclipse.birt.report.engine.nLayout.area.style.BackgroundImageInfo;
import org.eclipse.birt.report.engine.nLayout.area.style.BoxStyle;
import org.eclipse.birt.report.engine.presentation.UnresolvedRowHint;
import org.eclipse.birt.report.engine.util.ResourceLocatorWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableArea
extends RepeatableArea {
    protected transient TableLayoutInfo layoutInfo;
    protected transient TableLayout layout;
    protected RowArea unresolvedRow;
    protected int startCol;
    protected int endCol;
    protected boolean setUnresolvedRow = false;

    public TableArea(ContainerArea parent, LayoutContext context, IContent content) {
        super(parent, context, content);
    }

    TableArea(TableArea table) {
        super(table);
        this.layout = table.layout;
    }

    public boolean contains(RowArea row) {
        return this.children.contains(row);
    }

    public void addRow(RowArea row) {
        if (this.layout != null) {
            this.layout.addRow(row, this.context.isFixedLayout());
        }
    }

    public int getColumnCount() {
        if (this.content != null) {
            return ((ITableContent)this.content).getColumnCount();
        }
        return 0;
    }

    @Override
    protected boolean needRepeat() {
        ITableContent table = (ITableContent)this.content;
        return table != null && table.isHeaderRepeat();
    }

    @Override
    public TableArea cloneArea() {
        return new TableArea(this);
    }

    public int getXPos(int columnID) {
        if (this.layoutInfo != null) {
            return this.layoutInfo.getXPosition(columnID);
        }
        return 0;
    }

    public boolean isGridDesign() {
        if (this.content != null) {
            Object gen = this.content.getGenerateBy();
            return gen instanceof GridItemDesign;
        }
        return false;
    }

    @Override
    protected void buildProperties(IContent content, LayoutContext context) {
        IStyle style = content.getStyle();
        if (style != null && !style.isEmpty()) {
            String url;
            this.boxStyle = new BoxStyle();
            IStyle cs = content.getComputedStyle();
            Color color = PropertyUtil.getColor(cs.getProperty(25));
            if (color != null) {
                this.boxStyle.setBackgroundColor(color);
            }
            if ((url = style.getBackgroundImage()) != null) {
                ResourceLocatorWrapper rl = null;
                ExecutionContext exeContext = ((ReportContent)content.getReportContent()).getExecutionContext();
                if (exeContext != null) {
                    rl = exeContext.getResourceLocator();
                }
                BackgroundImageInfo backgroundImage = new BackgroundImageInfo(this.getImageUrl(url), style.getProperty(15), 0, 0, 0, 0, rl);
                this.boxStyle.setBackgroundImage(backgroundImage);
            }
            this.localProperties = new LocalProperties();
            int maw = this.parent.getMaxAvaWidth();
            this.localProperties.setMarginBottom(this.getDimensionValue(cs.getProperty(16), maw));
            this.localProperties.setMarginLeft(this.getDimensionValue(cs.getProperty(0), maw));
            this.localProperties.setMarginTop(this.getDimensionValue(cs.getProperty(2), maw));
            this.localProperties.setMarginRight(this.getDimensionValue(cs.getProperty(1), maw));
            if (!this.isInlineStacking) {
                this.pageBreakAfter = cs.getProperty(58);
                this.pageBreakInside = cs.getProperty(57);
                this.pageBreakBefore = cs.getProperty(47);
            }
        } else {
            this.hasStyle = false;
            this.boxStyle = BoxStyle.DEFAULT;
            this.localProperties = LocalProperties.DEFAULT;
        }
        this.bookmark = content.getBookmark();
        this.action = content.getHyperlinkAction();
    }

    @Override
    public void initialize() throws BirtException {
        this.calculateSpecifiedWidth(this.content);
        this.buildProperties(this.content, this.context);
        this.layoutInfo = this.resolveTableFixedLayout(this.content, this.context);
        this.width = this.layoutInfo.getTableWidth();
        this.maxAvaWidth = this.layoutInfo.getTableWidth();
        ITableContent tableContent = (ITableContent)this.content;
        int start = 0;
        int end = tableContent.getColumnCount() - 1;
        this.layout = new TableLayout(tableContent, this.layoutInfo, start, end);
        this.parent.add(this);
        this.addCaption(((ITableContent)this.content).getCaption());
    }

    protected void addCaption(String caption) throws BirtException {
        if (caption == null || "".equals(caption)) {
            return;
        }
        ReportContent report = (ReportContent)this.content.getReportContent();
        IRowContent row = report.createRowContent();
        row.setParent(this.content);
        ICellContent cell = report.createCellContent();
        cell.setColSpan(this.getColumnCount());
        cell.setColumn(0);
        StyleDeclaration cstyle = new StyleDeclaration(report.getCSSEngine());
        cstyle.setProperty(46, IStyle.HIDDEN_VALUE);
        cstyle.setProperty(40, IStyle.HIDDEN_VALUE);
        cstyle.setProperty(19, IStyle.HIDDEN_VALUE);
        cell.setInlineStyle(cstyle);
        cell.setParent(row);
        ILabelContent captionLabel = report.createLabelContent();
        captionLabel.setParent(cell);
        captionLabel.setText(caption);
        StyleDeclaration style = new StyleDeclaration(report.getCSSEngine());
        style.setProperty(24, IStyle.CENTER_VALUE);
        captionLabel.setInlineStyle(style);
        RowArea captionRow = new RowArea(this, this.context, row);
        captionRow.isDummy = true;
        captionRow.setParent(this);
        captionRow.setWidth(this.width);
        captionRow.initialize();
        CellArea captionCell = new CellArea(captionRow, this.context, cell);
        captionCell.setWidth(this.width);
        captionCell.setMaxAvaWidth(this.width);
        captionCell.initialize();
        captionCell.isDummy = true;
        captionCell.setRowSpan(1);
        captionRow.children.add(captionCell);
        BlockTextArea captionText = new BlockTextArea(captionCell, this.context, captionLabel);
        captionText.isDummy = true;
        captionText.layout();
        int h = captionText.getAllocatedHeight();
        captionCell.setContentHeight(h);
        captionRow.setHeight(captionCell.getAllocatedHeight());
        captionRow.finished = true;
        this.add(captionRow);
        if (this.repeatList == null) {
            this.repeatList = new ArrayList();
        }
        this.repeatList.add(captionRow);
        this.update(captionRow);
    }

    protected boolean isInHeaderBand() {
        ContainerArea child;
        IContent childContent;
        if (this.children.size() > 0 && (childContent = (child = (ContainerArea)this.children.get(this.children.size() - 1)).getContent()) != null) {
            int type;
            if (childContent.getContentType() == 17) {
                return false;
            }
            IContent band = (IContent)childContent.getParent();
            if (band instanceof IBandContent && (type = ((IBandContent)band).getBandType()) != 1) {
                return false;
            }
        }
        return true;
    }

    @Override
    public ContainerArea.SplitResult split(int height, boolean force) throws BirtException {
        ContainerArea.SplitResult result = super.split(height, force);
        if (result.getResult() != null) {
            InstanceID unresolvedTableIID;
            FixedLayoutPageHintGenerator pageHintGenerator;
            TableArea tableResult = (TableArea)result.getResult();
            this.unresolvedRow = tableResult.getLastRow();
            int h = tableResult.layout.resolveAll(this.unresolvedRow);
            if (h > 0) {
                tableResult.setHeight(tableResult.getHeight() + h);
            }
            tableResult.resolveBottomBorder();
            if (this.context.isFixedLayout() && (pageHintGenerator = this.context.getPageHintGenerator()) != null && this.unresolvedRow != null && (unresolvedTableIID = this.unresolvedRow.getTableArea().getContent().getInstanceID()) != null) {
                pageHintGenerator.addUnresolvedRowHint(unresolvedTableIID.toUniqueString(), this.convertRowToHint(this.unresolvedRow));
            }
        }
        this.relayoutChildren();
        return result;
    }

    private UnresolvedRowHint convertRowToHint(RowArea row) {
        IRowContent rowContent = (IRowContent)row.getContent();
        ITableContent table = rowContent.getTable();
        InstanceID tableId = table.getInstanceID();
        InstanceID rowId = rowContent.getInstanceID();
        UnresolvedRowHint hint = new UnresolvedRowHint(tableId.toUniqueString(), rowId.toUniqueString());
        if (row.cells != null) {
            int i = 0;
            while (i < row.cells.length) {
                ICellContent cellContent;
                CellArea cell;
                CellArea area = row.cells[i];
                String style = null;
                if (area instanceof DummyCell) {
                    cell = ((DummyCell)area).getCell();
                    cellContent = (ICellContent)cell.getContent();
                    if (cellContent != null) {
                        style = cellContent.getStyle().getCssText();
                    }
                    hint.addUnresolvedCell(style, cell.columnID, ((DummyCell)area).colSpan, ((DummyCell)area).rowSpan);
                } else if (area instanceof CellArea) {
                    cell = area;
                    cellContent = (ICellContent)cell.getContent();
                    if (cellContent != null) {
                        style = cellContent.getStyle().getCssText();
                    }
                    hint.addUnresolvedCell(style, cellContent.getColumn(), cellContent.getColSpan(), cellContent.getRowSpan());
                }
                ++i;
            }
        }
        return hint;
    }

    protected RowArea getLastRow(ContainerArea container) {
        int count = container.getChildrenCount();
        int i = count - 1;
        while (i >= 0) {
            IArea child = container.getChild(i);
            if (child instanceof RowArea) {
                return (RowArea)child;
            }
            if (child instanceof ContainerArea) {
                RowArea lastRow = this.getLastRow((ContainerArea)child);
                if (lastRow != null) {
                    return lastRow;
                }
            } else {
                return null;
            }
            --i;
        }
        return null;
    }

    protected RowArea getLastRow() {
        return this.getLastRow(this);
    }

    public void resolveBottomBorder() {
        RowArea lastRow = this.getLastRow();
        if (lastRow != null && lastRow.cells != null) {
            int bw = 0;
            int i = 0;
            while (i < lastRow.cells.length) {
                if (lastRow.cells[i] != null) {
                    bw = Math.max(bw, this.layout.resolveBottomBorder(lastRow.cells[i]));
                    i = i + lastRow.cells[i].getColSpan() - 1;
                }
                ++i;
            }
            if (bw > 0) {
                lastRow.setHeight(bw + lastRow.getHeight());
                i = 0;
                while (i < lastRow.cells.length) {
                    if (lastRow.cells[i] != null) {
                        if (lastRow.cells[i] instanceof DummyCell) {
                            ((DummyCell)lastRow.cells[i]).getCell();
                        } else {
                            lastRow.cells[i].setHeight(lastRow.cells[i].getHeight() + bw);
                        }
                        i = i + lastRow.cells[i].getColSpan() - 1;
                    }
                    ++i;
                }
            }
        }
    }

    protected String getNextRowId(RowArea row) {
        InstanceID id;
        RowArea nextRow = this.layout.getNextRow(row);
        if (nextRow != null && (id = nextRow.getContent().getInstanceID()) != null) {
            return id.toUniqueString();
        }
        return null;
    }

    protected void setUnresolvedRow() {
        if (!this.setUnresolvedRow) {
            this.layout.setUnresolvedRow(this.unresolvedRow);
            this.setUnresolvedRow = true;
        }
    }

    public void relayoutChildren() throws BirtException {
        String nextRowId = null;
        if (this.unresolvedRow != null) {
            nextRowId = this.getNextRowId(this.unresolvedRow);
        }
        this.layout.clear();
        this.setUnresolvedRow = false;
        ArrayList<RowArea> rows = new ArrayList<RowArea>();
        this.collectRows(this, this.layout, rows);
        int rowCount = this.getRowCountNeedResolved(rows, nextRowId);
        boolean resolved = false;
        if (rowCount > 0 && this.unresolvedRow != null) {
            int i = 0;
            while (i < rowCount) {
                resolved = this.resolveRowSpan((RowArea)rows.get(i), this.unresolvedRow, rowCount - i) || resolved;
                ++i;
            }
        }
        this.addRows(this, this.layout, nextRowId);
        if (!resolved) {
            this.setUnresolvedRow();
        }
    }

    protected boolean resolveRowSpan(RowArea row, RowArea unresolvedRow, int rowCount) {
        boolean resolved = false;
        int i = this.startCol;
        while (i <= this.endCol) {
            CellArea cell = row.getCell(i);
            CellArea uCell = unresolvedRow.getCell(i);
            if (cell != null && uCell != null) {
                IContent uCellContent;
                IContent cellContent = cell.getContent();
                if (cellContent == (uCellContent = cell.getContent())) {
                    int rowSpan = 0;
                    rowSpan = unresolvedRow.finished ? uCell.getRowSpan() + rowCount - 1 : uCell.getRowSpan() + rowCount;
                    if (rowSpan < cell.getRowSpan() && rowSpan >= 1) {
                        cell.setRowSpan(rowSpan);
                        resolved = true;
                        this.setUnresolvedRow = true;
                    }
                }
                i += cell.getColSpan();
            }
            ++i;
        }
        return resolved;
    }

    protected int getRowCountNeedResolved(List<RowArea> rows, String rowId) {
        int i = 0;
        while (i < rows.size()) {
            RowArea row = rows.get(i);
            InstanceID id = row.getContent().getInstanceID();
            if (rowId != null && id != null && rowId.equals(id.toUniqueString())) {
                return i;
            }
            ++i;
        }
        return rows.size();
    }

    protected void collectRows(ContainerArea container, TableLayout layout, List<RowArea> rows) {
        if (container instanceof RowArea) {
            RowArea row = (RowArea)container;
            if (row.finished) {
                rows.add(row);
            }
        } else {
            int size = container.getChildrenCount();
            int i = 0;
            while (i < size) {
                ContainerArea child = (ContainerArea)container.getChild(i);
                this.collectRows(child, layout, rows);
                ++i;
            }
        }
    }

    protected void addRows(ContainerArea container, TableLayout layout, String rowId) throws BirtException {
        if (container instanceof RowArea) {
            RowArea row = (RowArea)container;
            InstanceID id = row.getContent().getInstanceID();
            if (rowId != null && id != null && rowId.equals(id.toUniqueString())) {
                this.setUnresolvedRow();
            }
            if (row.needResolveBorder) {
                int size = row.getChildrenCount();
                int i = 0;
                while (i < size) {
                    CellArea cell = (CellArea)row.getChild(i);
                    int ch = cell.getContentHeight();
                    cell.boxStyle.clearBorder();
                    layout.resolveBorderConflict(cell, true);
                    cell.setContentHeight(ch);
                    ++i;
                }
                row.needResolveBorder = false;
            }
            if (row.finished) {
                if (row.getChildrenCount() != row.cells.length) {
                    int i = 0;
                    while (i < row.cells.length) {
                        if (row.cells[i] instanceof DummyCell) {
                            row.cells[i] = null;
                        }
                        ++i;
                    }
                }
                layout.addRow(row, this.context.isFixedLayout());
            }
        } else {
            int size = container.getChildrenCount();
            int i = 0;
            while (i < size) {
                ContainerArea child = (ContainerArea)container.getChild(i);
                this.addRows(child, layout, rowId);
                child.updateChildrenPosition();
                ++i;
            }
            container.updateChildrenPosition();
        }
    }

    @Override
    public void close() throws BirtException {
        int borderHeight = 0;
        if (this.layout != null) {
            int height = this.layout.resolveAll(this.getLastRow());
            if (height != 0) {
                this.currentBP += height;
            }
            borderHeight = this.layout.resolveBottomBorder();
            this.layout.remove(this);
        }
        this.setHeight(this.currentBP + this.getOffsetY() + borderHeight);
        this.updateBackgroundImage();
        if (this.parent != null) {
            boolean pb;
            IContent parentContent = this.parent.getContent();
            if (parentContent != null && parentContent.isRTL()) {
                this.flipPositionForRtl();
            }
            if (pb = this.checkPageBreak()) {
                int height = this.layout.resolveAll(this.getLastRow());
                if (height != 0) {
                    this.currentBP += height;
                }
                borderHeight = this.layout.resolveBottomBorder();
                this.layout.remove(this);
            }
            this.parent.update(this);
        }
        this.finished = true;
    }

    public int getCellWidth(int startColumn, int endColumn) {
        if (this.layoutInfo != null) {
            return this.layoutInfo.getCellWidth(startColumn, endColumn);
        }
        return 0;
    }

    public void resolveBorderConflict(CellArea cellArea, boolean isFirst) {
        if (this.layout != null) {
            this.layout.resolveBorderConflict(cellArea, isFirst);
        }
    }

    private TableLayoutInfo resolveTableFixedLayout(IContent content, LayoutContext context) {
        assert (this.parent != null);
        int parentMaxWidth = this.parent.getMaxAvaWidth();
        int marginWidth = this.localProperties.getMarginLeft() + this.localProperties.getMarginRight();
        return new TableLayoutInfo((ITableContent)content, context, new ColumnWidthResolver((ITableContent)content).resolveFixedLayout(parentMaxWidth - marginWidth));
    }

    private class ColumnWidthResolver {
        ITableContent table;

        public ColumnWidthResolver(ITableContent table) {
            this.table = table;
        }

        protected int[] formalize(DimensionType[] columns, int tableWidth, boolean isTableWidthDefined) {
            int[] resolvedColumnWidth;
            block24: {
                int left;
                int fixedLength;
                double total;
                ArrayList<Integer> unsetList;
                ArrayList<Integer> percentageList;
                block22: {
                    block23: {
                        percentageList = new ArrayList<Integer>();
                        unsetList = new ArrayList<Integer>();
                        ArrayList<Integer> preFixedList = new ArrayList<Integer>();
                        resolvedColumnWidth = new int[columns.length];
                        total = 0.0;
                        fixedLength = 0;
                        int i = 0;
                        while (i < columns.length) {
                            int len;
                            if (columns[i] == null) {
                                unsetList.add(i);
                            } else if ("%".equals(columns[i].getUnits())) {
                                percentageList.add(i);
                                total += columns[i].getMeasure();
                            } else if ("em".equals(columns[i].getUnits()) || "ex".equals(columns[i].getUnits())) {
                                resolvedColumnWidth[i] = len = TableArea.this.getDimensionValue(this.table, columns[i], TableArea.this.getDimensionValue(this.table.getComputedStyle().getProperty(44)));
                                fixedLength += len;
                            } else {
                                resolvedColumnWidth[i] = len = TableArea.this.getDimensionValue(this.table, columns[i], tableWidth);
                                preFixedList.add(i);
                                fixedLength += len;
                            }
                            ++i;
                        }
                        if (!isTableWidthDefined && unsetList.isEmpty() && percentageList.isEmpty()) {
                            return resolvedColumnWidth;
                        }
                        if (fixedLength >= tableWidth) {
                            i = 0;
                            while (i < unsetList.size()) {
                                Integer index = (Integer)unsetList.get(i);
                                resolvedColumnWidth[index.intValue()] = 0;
                                ++i;
                            }
                            i = 0;
                            while (i < percentageList.size()) {
                                Integer index = (Integer)percentageList.get(i);
                                resolvedColumnWidth[index.intValue()] = 0;
                                ++i;
                            }
                            return resolvedColumnWidth;
                        }
                        if (!unsetList.isEmpty()) break block22;
                        if (!percentageList.isEmpty()) break block23;
                        left = tableWidth - fixedLength;
                        if (preFixedList.isEmpty()) break block24;
                        int delta = left / preFixedList.size();
                        int i2 = 0;
                        while (i2 < preFixedList.size()) {
                            Integer index = (Integer)preFixedList.get(i2);
                            int n = index;
                            resolvedColumnWidth[n] = resolvedColumnWidth[n] + delta;
                            ++i2;
                        }
                        break block24;
                    }
                    float leftPercentage = (float)(tableWidth - fixedLength) / (float)tableWidth * 100.0f;
                    double ratio = (double)leftPercentage / total;
                    int i = 0;
                    while (i < percentageList.size()) {
                        Integer index = (Integer)percentageList.get(i);
                        columns[index.intValue()] = new DimensionType(columns[index].getMeasure() * ratio, columns[index].getUnits());
                        resolvedColumnWidth[index.intValue()] = TableArea.this.getDimensionValue(this.table, columns[index], tableWidth);
                        ++i;
                    }
                    break block24;
                }
                if (percentageList.isEmpty()) {
                    left = tableWidth - fixedLength;
                    int eachWidth = left / unsetList.size();
                    int i = 0;
                    while (i < unsetList.size()) {
                        Integer index = (Integer)unsetList.get(i);
                        resolvedColumnWidth[index.intValue()] = eachWidth;
                        ++i;
                    }
                } else {
                    float leftPercentage = (float)(tableWidth - fixedLength) / (float)tableWidth * 100.0f;
                    if ((double)leftPercentage <= total) {
                        Integer index;
                        double ratio = (double)leftPercentage / total;
                        int i = 0;
                        while (i < unsetList.size()) {
                            index = (Integer)unsetList.get(i);
                            resolvedColumnWidth[index.intValue()] = 0;
                            ++i;
                        }
                        i = 0;
                        while (i < percentageList.size()) {
                            index = (Integer)percentageList.get(i);
                            columns[index.intValue()] = new DimensionType(columns[index].getMeasure() * ratio, columns[index].getUnits());
                            resolvedColumnWidth[index.intValue()] = TableArea.this.getDimensionValue(this.table, columns[index], tableWidth);
                            ++i;
                        }
                    } else {
                        int usedLength = fixedLength;
                        int i = 0;
                        while (i < percentageList.size()) {
                            Integer index = (Integer)percentageList.get(i);
                            int width = TableArea.this.getDimensionValue(this.table, columns[index], tableWidth);
                            usedLength += width;
                            resolvedColumnWidth[index.intValue()] = width;
                            ++i;
                        }
                        int left2 = tableWidth - usedLength;
                        int eachWidth = left2 / unsetList.size();
                        int i3 = 0;
                        while (i3 < unsetList.size()) {
                            Integer index = (Integer)unsetList.get(i3);
                            resolvedColumnWidth[index.intValue()] = eachWidth;
                            ++i3;
                        }
                    }
                }
            }
            return resolvedColumnWidth;
        }

        public int[] resolveFixedLayout(int maxWidth) {
            int tableWidth;
            int columnNumber = this.table.getColumnCount();
            DimensionType[] columns = new DimensionType[columnNumber];
            int i = 0;
            while (i < columnNumber) {
                IColumn column = this.table.getColumn(i);
                DimensionType w = column.getWidth();
                if (TableArea.this.startCol < 0) {
                    TableArea.this.startCol = i;
                }
                TableArea.this.endCol = i;
                columns[i] = w == null ? null : new DimensionType(w.getMeasure(), w.getUnits());
                ++i;
            }
            if (TableArea.this.startCol < 0) {
                TableArea.this.startCol = 0;
            }
            if (TableArea.this.endCol < 0) {
                TableArea.this.endCol = 0;
            }
            boolean isTableWidthDefined = false;
            int specifiedWidth = TableArea.this.getDimensionValue(this.table, this.table.getWidth(), maxWidth);
            if (specifiedWidth > 0) {
                tableWidth = specifiedWidth;
                isTableWidthDefined = true;
            } else {
                tableWidth = maxWidth;
                isTableWidthDefined = false;
            }
            return this.formalize(columns, tableWidth, isTableWidthDefined);
        }

        public int[] resolve(int specifiedWidth, int maxWidth) {
            assert (specifiedWidth <= maxWidth);
            int columnNumber = this.table.getColumnCount();
            int[] columns = new int[columnNumber];
            int columnWithWidth = 0;
            int colSum = 0;
            int j = 0;
            while (j < this.table.getColumnCount()) {
                IColumn column = this.table.getColumn(j);
                int columnWidth = TableArea.this.getDimensionValue(this.table, column.getWidth(), TableArea.this.width);
                if (columnWidth > 0) {
                    columns[j] = columnWidth;
                    colSum += columnWidth;
                    ++columnWithWidth;
                } else {
                    columns[j] = -1;
                }
                ++j;
            }
            if (columnWithWidth == columnNumber) {
                if (colSum <= maxWidth) {
                    return columns;
                }
                float delta = colSum - maxWidth;
                int i = 0;
                while (i < columnNumber) {
                    int n = i;
                    columns[n] = columns[n] - (int)(delta * (float)columns[i] / (float)colSum);
                    ++i;
                }
                return columns;
            }
            if (specifiedWidth == 0) {
                if (colSum < maxWidth) {
                    this.distributeLeftWidth(columns, (maxWidth - colSum) / (columnNumber - columnWithWidth));
                } else {
                    this.redistributeWidth(columns, colSum - maxWidth + (columnNumber - columnWithWidth) * maxWidth / columnNumber, maxWidth, colSum);
                }
            } else if (colSum < specifiedWidth) {
                this.distributeLeftWidth(columns, (specifiedWidth - colSum) / (columnNumber - columnWithWidth));
            } else if (colSum < maxWidth) {
                this.distributeLeftWidth(columns, (maxWidth - colSum) / (columnNumber - columnWithWidth));
            } else {
                this.redistributeWidth(columns, colSum - specifiedWidth + (columnNumber - columnWithWidth) * specifiedWidth / columnNumber, specifiedWidth, colSum);
            }
            return columns;
        }

        private void redistributeWidth(int[] cols, int delta, int sum, int currentSum) {
            int avaWidth = sum / cols.length;
            int i = 0;
            while (i < cols.length) {
                if (cols[i] < 0) {
                    cols[i] = avaWidth;
                } else {
                    int n = i;
                    cols[n] = cols[n] - (int)((float)cols[i] * (float)delta / (float)currentSum);
                }
                ++i;
            }
        }

        private void distributeLeftWidth(int[] cols, int avaWidth) {
            int i = 0;
            while (i < cols.length) {
                if (cols[i] < 0) {
                    cols[i] = avaWidth;
                }
                ++i;
            }
        }
    }

    public static class TableLayoutInfo {
        ITableContent tableContent;
        LayoutContext context;
        protected int columnNumber;
        protected int tableWidth;
        protected int[] colWidth = null;
        protected int[] xPositions = null;

        public TableLayoutInfo(ITableContent tableContent, LayoutContext context, int[] colWidth) {
            this.tableContent = tableContent;
            this.context = context;
            this.colWidth = colWidth;
            this.columnNumber = colWidth.length;
            this.xPositions = new int[this.columnNumber];
            this.tableWidth = 0;
            int i = 0;
            while (i < this.columnNumber) {
                this.xPositions[i] = this.tableWidth;
                this.tableWidth += colWidth[i];
                ++i;
            }
        }

        public int getTableWidth() {
            return this.tableWidth;
        }

        public int getXPosition(int index) {
            return this.xPositions[index];
        }

        public int getCellWidth(int startColumn, int endColumn) {
            assert (startColumn < endColumn);
            assert (this.colWidth != null);
            int sum = 0;
            int i = startColumn;
            while (i < endColumn) {
                sum += this.colWidth[i];
                ++i;
            }
            return sum;
        }

        private void addDummyColumnForRTL(int[] colWidth) {
            this.colWidth = new int[this.columnNumber + 1];
            System.arraycopy(colWidth, 0, this.colWidth, 0, this.columnNumber);
            this.colWidth[this.columnNumber] = this.xPositions[this.columnNumber - 1];
            int[] newXPositions = new int[this.columnNumber + 1];
            System.arraycopy(this.xPositions, 0, newXPositions, 0, this.columnNumber);
            this.xPositions = newXPositions;
            this.xPositions[this.columnNumber] = 0;
            this.tableWidth += this.colWidth[this.columnNumber - 1];
            ++this.columnNumber;
        }
    }
}

