/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.nLayout.area.impl;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.nLayout.LayoutContext;
import org.eclipse.birt.report.engine.nLayout.area.IArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.CellArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.DummyCell;
import org.eclipse.birt.report.engine.nLayout.area.impl.TableArea;

public class RowArea
extends ContainerArea {
    protected transient CellArea[] cells;
    protected transient TableArea table;
    protected int rowID;
    protected boolean needResolveBorder = false;

    public RowArea(ContainerArea parent, LayoutContext context, IContent content) {
        super(parent, context, content);
        this.cells = new CellArea[this.getTable().getColumnCount()];
        this.isInInlineStacking = parent.isInInlineStacking;
    }

    RowArea(int colCount) {
        this.cells = new CellArea[colCount];
    }

    RowArea(RowArea row) {
        super(row);
        this.rowID = row.getRowID();
        this.cells = new CellArea[row.getColumnCount()];
    }

    public int getColumnCount() {
        TableArea table = this.getTableArea();
        if (table != null) {
            return table.getColumnCount();
        }
        if (this.cells != null) {
            return this.cells.length;
        }
        return 0;
    }

    public void setCell(CellArea cell) {
        int col = cell.getColumnID();
        int colSpan = cell.getColSpan();
        int i = col;
        while (i < col + colSpan) {
            this.cells[i] = cell;
            ++i;
        }
    }

    public CellArea getCell(int columnID) {
        if (columnID >= 0 && columnID < this.cells.length) {
            return this.cells[columnID];
        }
        return null;
    }

    public void replace(CellArea origin, CellArea dest) {
        int index = this.children.indexOf(origin);
        if (index >= 0) {
            this.children.remove(origin);
            this.children.add(index, dest);
            dest.setParent(this);
        }
    }

    public void setRowID(int rowID) {
        this.rowID = rowID;
    }

    public int getRowID() {
        return this.rowID;
    }

    public RowArea cloneArea() {
        return new RowArea(this);
    }

    public RowArea deepClone() {
        RowArea result = this.cloneArea();
        for (CellArea child : this.children) {
            CellArea cloneChild = child.deepClone();
            result.children.add(cloneChild);
            cloneChild.setParent(result);
            result.setCell(cloneChild);
        }
        return result;
    }

    protected TableArea getTableArea() {
        if (this.table == null) {
            this.table = this.getTable();
        }
        return this.table;
    }

    public void close() throws BirtException {
        TableArea table = this.getTableArea();
        table.addRow(this);
        this.updateBackgroundImage();
        boolean pb = this.checkPageBreak();
        if (pb) {
            this.specifiedHeight = 0;
            table.addRow(this);
        }
        this.parent.update(this);
        this.finished = true;
    }

    public void initialize() throws BirtException {
        this.calculateSpecifiedHeight(this.content);
        this.width = this.parent.getMaxAvaWidth();
        this.buildLogicContainerProperties(this.content, this.context);
        this.parent.add(this);
    }

    protected boolean isRowEmpty() {
        Iterator<IArea> iter = this.getChildren();
        while (iter.hasNext()) {
            ContainerArea area = (ContainerArea)iter.next();
            if (area.getChildrenCount() <= 0) continue;
            return false;
        }
        return true;
    }

    public void update(AbstractArea area) throws BirtException {
        CellArea cArea = (CellArea)area;
        int columnID = cArea.getColumnID();
        cArea.setPosition(this.getTableArea().getXPos(columnID), 0);
        if (this.content != null && this.content.isRTL()) {
            cArea.flipPositionForRtl();
        }
    }

    public void add(AbstractArea area) {
        this.addChild(area);
        CellArea cArea = (CellArea)area;
        int columnID = cArea.getColumnID();
        cArea.setPosition(this.getTableArea().getXPos(columnID), 0);
        if (this.content != null && this.content.isRTL()) {
            cArea.flipPositionForRtl();
        }
    }

    public void addChild(IArea area) {
        this.children.add(area);
        this.setCell((CellArea)area);
    }

    public void addChildByColumnId(CellArea cell) {
        int columnId = cell.getColumnID();
        int index = 0;
        int i = 0;
        while (i < this.children.size()) {
            CellArea current = (CellArea)this.children.get(i);
            if (current.getColumnID() >= columnId) {
                index = i;
                this.children.add(index, cell);
                this.setCell(cell);
                return;
            }
            ++i;
        }
        this.children.add(this.children.size(), cell);
        this.setCell(cell);
    }

    public ContainerArea.SplitResult split(int height, boolean force) throws BirtException {
        if (force) {
            return this._split(height, force);
        }
        if (this.isPageBreakInsideAvoid()) {
            if (this.isPageBreakBeforeAvoid()) {
                return ContainerArea.SplitResult.BEFORE_AVOID_WITH_NULL;
            }
            this._splitSpanCell(height, force);
            this.needResolveBorder = true;
            return ContainerArea.SplitResult.SUCCEED_WITH_NULL;
        }
        return this._split(height, force);
    }

    protected void _splitSpanCell(int height, boolean force) throws BirtException {
        if (this.cells.length != this.children.size()) {
            int i = 0;
            while (i < this.cells.length) {
                if (this.cells[i] instanceof DummyCell) {
                    int oh = ((DummyCell)this.cells[i]).getCell().getHeight();
                    int ch = ((DummyCell)this.cells[i]).getDelta();
                    int rowSpan = ((DummyCell)this.cells[i]).getRowSpan();
                    if (ch >= oh) {
                        CellArea cell = this.cells[i].cloneArea();
                        cell.setHeight(0);
                        cell.setRowSpan(rowSpan);
                        cell.setParent(this);
                        cell.isDummy = true;
                        this.addChildByColumnId(cell);
                    } else {
                        ContainerArea.SplitResult splitCell = this.cells[i].split(height, force);
                        CellArea cell = (CellArea)splitCell.getResult();
                        if (cell != null) {
                            CellArea oc = ((DummyCell)this.cells[i]).getCell();
                            ArrayList temp = cell.children;
                            cell.children = oc.children;
                            oc.children = temp;
                            oc.updateChildrenPosition();
                            cell.updateChildrenPosition();
                            cell.setRowSpan(rowSpan);
                            cell.setParent(this);
                            cell.isDummy = true;
                            this.addChildByColumnId(cell);
                        } else {
                            cell = this.cells[i].cloneArea();
                            cell.setHeight(0);
                            cell.setRowSpan(rowSpan);
                            cell.setParent(this);
                            cell.isDummy = true;
                            this.addChildByColumnId(cell);
                        }
                    }
                    i = i + this.cells[i].getColSpan() - 1;
                }
                ++i;
            }
        }
    }

    protected ContainerArea.SplitResult _split(int height, boolean force) throws BirtException {
        RowArea result = null;
        int i = 0;
        while (i < this.cells.length) {
            if (this.cells[i] != null) {
                ContainerArea.SplitResult splitCell = this.cells[i].split(height, force);
                CellArea cell = (CellArea)splitCell.getResult();
                if (cell != null) {
                    if (result == null) {
                        result = this.cloneArea();
                    }
                    result.addChild(cell);
                    result.setCell(cell);
                    cell.setParent(result);
                }
                i = this.cells[i].getColSpan() + i - 1;
            }
            ++i;
        }
        if (result != null) {
            result.updateRow(this);
            result.needResolveBorder = true;
            this.updateRow();
            this.needResolveBorder = true;
            return new ContainerArea.SplitResult(result, 0);
        }
        this.updateRow();
        this.needResolveBorder = true;
        return ContainerArea.SplitResult.SUCCEED_WITH_NULL;
    }

    protected void updateRow() {
        CellArea cell;
        int height = 0;
        int i = 0;
        while (i < this.children.size()) {
            cell = (CellArea)this.children.get(i);
            height = Math.max(height, cell.getHeight());
            ++i;
        }
        this.height = height;
        i = 0;
        while (i < this.children.size()) {
            cell = (CellArea)this.children.get(i);
            cell.setHeight(height);
            this.setCell(cell);
            ++i;
        }
    }

    public void updateRow(RowArea original) {
        int height = 0;
        for (CellArea cell : this.children) {
            height = Math.max(height, cell.getHeight());
        }
        this.height = height;
        int i = 0;
        while (i < this.cells.length) {
            if (this.cells[i] == null) {
                CellArea oCell = original.getCell(i);
                if (oCell != null && !(oCell instanceof DummyCell)) {
                    CellArea nCell = oCell.cloneArea();
                    nCell.setHeight(height);
                    nCell.setParent(this);
                    this.addChildByColumnId(nCell);
                    i = i + oCell.getColSpan() - 1;
                }
            } else {
                this.cells[i].setHeight(height);
            }
            ++i;
        }
    }

    public boolean isPageBreakInsideAvoid() {
        IStyle style;
        String pb;
        if (this.getTableArea().isGridDesign()) {
            return super.isPageBreakInsideAvoid();
        }
        if (IStyle.AVOID_VALUE == this.pageBreakInside) {
            return true;
        }
        return this.content == null || !"auto".equals(pb = (style = this.content.getStyle()).getPageBreakInside());
    }

    public ContainerArea.SplitResult splitLines(int lineCount) throws BirtException {
        if (this.isPageBreakBeforeAvoid()) {
            return ContainerArea.SplitResult.BEFORE_AVOID_WITH_NULL;
        }
        return ContainerArea.SplitResult.SUCCEED_WITH_NULL;
    }

    public void updateChildrenPosition() throws BirtException {
    }
}

