/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.build.framework;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.jar.Manifest;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.birt.build.framework.Bundle;
import org.xml.sax.SAXException;

public class BundleLoader {
    static final String BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    static final String BUNDLE_VERSION = "Bundle-Version";
    static final String BUNDLE_LOCALIZATION = "Bundle-Localization";
    static final String MANIFEST_ENTRY = "META-INF/MANIFEST.MF";
    static final String PLUGIN_ENTRY = "plugin.xml";
    static final String FRAGMENT_ENTRY = "fragment.xml";
    static final String PROPERTIES_ENTRY = "plugin.properties";
    protected URL root;
    protected Bundle bundle;
    protected Properties properties;

    BundleLoader(URL root) {
        this.root = root;
    }

    Bundle load(URL root) throws IOException, ParserConfigurationException, SAXException {
        Manifest manifest = this.loadManifest(root);
        String localizationEntry = (String)manifest.getMainAttributes().get(BUNDLE_LOCALIZATION);
        if (localizationEntry != null) {
            this.properties = this.loadProperties(localizationEntry);
        }
        return this.bundle;
    }

    protected Manifest loadManifest(URL root) throws IOException {
        InputStream in = this.openInputStream(root, MANIFEST_ENTRY);
        if (in == null) {
            throw new IOException("can't load the META-INF/MANIFEST.MF");
        }
        try {
            Manifest manifest = new Manifest(in);
            return manifest;
        }
        finally {
            in.close();
        }
    }

    protected Properties loadProperties(String propertyEntryName) {
        InputStream in = this.openInputStream(this.root, propertyEntryName);
        if (in == null) {
            return null;
        }
        try {
            Properties properties = new Properties();
            properties.load(in);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    protected String localizeProperty(String key) {
        if (key != null && key.length() > 0 && key.charAt(0) == '%') {
            String value;
            key = key.substring(1);
            if (this.properties != null && (value = this.properties.getProperty(key)) != null) {
                return value;
            }
        }
        return key;
    }

    protected InputStream openInputStream(URL root, String name) {
        try {
            URL manifestUrl = new URL(root, name);
            InputStream in = manifestUrl.openStream();
            if (in != null) {
                return in;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

