/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.build;

public class StringUtil {
    public static String trimString(String value) {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() == 0) {
            return null;
        }
        return value;
    }

    public static String toRgbText(int rgb) {
        if (rgb > 0xFFFFFF) {
            rgb = 0xFFFFFF;
        }
        if (rgb < 0) {
            rgb = 0;
        }
        String str = "000000" + Integer.toHexString(rgb);
        return "#" + str.substring(str.length() - 6);
    }

    public static boolean isValidLocale(String locale) {
        return true;
    }

    public static boolean isBlank(String str) {
        return StringUtil.trimString(str) == null;
    }

    public static boolean isEmpty(String value) {
        return value == null || value.length() == 0;
    }

    public static boolean isEqual(String str1, String str2) {
        return str1 == str2 || str1 != null && str1.equals(str2);
    }

    public static boolean isEqualIgnoreCase(String str1, String str2) {
        return str1 == str2 || str1 != null && str1.equalsIgnoreCase(str2);
    }

    public static String doubleToString(double d, int fNumber) {
        int pos;
        if (fNumber < 0) {
            fNumber = 0;
        }
        String value = Double.toString(d);
        int ePos = value.indexOf(69);
        int dotPos = value.indexOf(46);
        if (ePos != -1) {
            String e = value.substring(ePos + 1);
            int exp = Integer.parseInt(e);
            StringBuilder sb = new StringBuilder(value.substring(0, dotPos));
            if (ePos - dotPos - 1 > exp) {
                sb.append(value.substring(dotPos + 1, dotPos + 1 + exp));
                sb.append('.');
                sb.append(value.substring(dotPos + 1 + exp, ePos));
            } else {
                sb.append(value.substring(dotPos + 1, ePos));
                int i = 0;
                while (i < exp - (ePos - dotPos - 1)) {
                    sb.append('0');
                    ++i;
                }
            }
            value = sb.toString();
        }
        if ((pos = value.indexOf(46)) != -1) {
            if (value.length() - pos - 1 > fNumber) {
                value = value.substring(0, pos + fNumber + 1);
            }
            int i = 0;
            while (i < fNumber) {
                if (value.charAt(value.length() - i - 1) != '0') break;
                ++i;
            }
            value = value.substring(0, value.length() - i);
            if (value.charAt(value.length() - 1) == '.') {
                value = value.substring(0, value.length() - 1);
            }
        }
        return value;
    }

    public static String extractFileName(String filePathName) {
        if (filePathName == null) {
            return null;
        }
        int dotPos = filePathName.lastIndexOf(46);
        int slashPos = filePathName.lastIndexOf(92);
        if (slashPos == -1) {
            slashPos = filePathName.lastIndexOf(47);
        }
        if (dotPos > slashPos) {
            return filePathName.substring(slashPos > 0 ? slashPos + 1 : 0, dotPos);
        }
        return filePathName.substring(slashPos > 0 ? slashPos + 1 : 0);
    }

    public static String extractFileNameWithSuffix(String filePathName) {
        if (filePathName == null) {
            return null;
        }
        int slashPos = filePathName.lastIndexOf(92);
        if (slashPos == -1) {
            slashPos = filePathName.lastIndexOf(47);
        }
        return filePathName.substring(slashPos > 0 ? slashPos + 1 : 0);
    }

    public static String extractNamespace(String qualifiedName) {
        if (qualifiedName == null) {
            return null;
        }
        int pos = qualifiedName.indexOf(46);
        if (pos == -1) {
            return null;
        }
        return StringUtil.trimString(qualifiedName.substring(0, pos));
    }

    public static String extractName(String qualifiedName) {
        if (qualifiedName == null) {
            return null;
        }
        int pos = qualifiedName.indexOf(46);
        if (pos == -1) {
            return qualifiedName;
        }
        return StringUtil.trimString(qualifiedName.substring(pos + 1));
    }
}

