/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.build;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import org.apache.tools.ant.Task;

public class CheckDiskSpace
extends Task {
    protected long threshold = 200L;
    protected String property = "notEnoughSpace";
    protected String path = ".";
    protected String value = "availableSpace";

    public void setThreshold(long value) {
        this.threshold = value;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void execute() {
        try {
            long ava = this.getFreeSpace(this.path);
            long m = 0x100000L;
            this.log("Available space in path " + this.path + " is " + ava / m + "M");
            this.getProject().setProperty(this.value, Long.toString(ava / m));
            if (this.threshold > ava / m) {
                this.getProject().setProperty(this.property, "true");
            }
        }
        catch (Exception ex) {
            this.log("Error occurred when checking the disk, the path :[" + this.path + "] may be incorrect for the current os", 1);
            this.log(ex.getMessage(), 1);
        }
    }

    private long getFreeSpaceOnLinux(String path) throws Exception {
        int c;
        long bytesFree = -1L;
        Process p = Runtime.getRuntime().exec("df /" + path);
        BufferedInputStream reader = new BufferedInputStream(p.getInputStream());
        StringBuilder buffer = new StringBuilder();
        while ((c = ((InputStream)reader).read()) != -1) {
            buffer.append((char)c);
        }
        String outputText = buffer.toString();
        ((InputStream)reader).close();
        StringTokenizer tokenizer = new StringTokenizer(outputText, "\n");
        tokenizer.nextToken();
        if (tokenizer.hasMoreTokens()) {
            String line2 = tokenizer.nextToken();
            StringTokenizer tokenizer2 = new StringTokenizer(line2, " ");
            if (tokenizer2.countTokens() >= 4) {
                tokenizer2.nextToken();
                tokenizer2.nextToken();
                tokenizer2.nextToken();
                bytesFree = Long.parseLong(tokenizer2.nextToken());
                return bytesFree * 1024L;
            }
            return bytesFree * 1024L;
        }
        throw new Exception("Can not read the free space of " + path + " path");
    }

    private long getFreeSpace(String path) throws Exception {
        if (System.getProperty("os.name").startsWith("Windows")) {
            return this.getFreeSpaceOnWindows(path);
        }
        if (System.getProperty("os.name").startsWith("Linux")) {
            return this.getFreeSpaceOnLinux(path);
        }
        throw new UnsupportedOperationException("The method getFreeSpace(String path) has not been implemented for this operating system.");
    }

    private long getFreeSpaceOnWindows(String path) throws Exception {
        int c;
        File script = new File(System.getProperty("java.io.tmpdir"), "script.bat");
        PrintWriter writer = new PrintWriter(new FileWriter(script, false));
        writer.println("dir \"" + path + "\"");
        writer.close();
        Process p = Runtime.getRuntime().exec(script.getAbsolutePath());
        BufferedInputStream reader = new BufferedInputStream(p.getInputStream());
        StringBuilder buffer = new StringBuilder();
        while ((c = ((InputStream)reader).read()) != -1) {
            buffer.append((char)c);
        }
        String outputText = buffer.toString();
        ((InputStream)reader).close();
        StringTokenizer tokenizer = new StringTokenizer(outputText, "\n");
        String line = null;
        while (tokenizer.hasMoreTokens()) {
            line = tokenizer.nextToken().trim();
        }
        tokenizer = new StringTokenizer(line, " ");
        tokenizer.nextToken();
        tokenizer.nextToken();
        long bytesFree = Long.parseLong(tokenizer.nextToken().replace(",", ""));
        return bytesFree;
    }
}

