/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.elements.structures;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.PropertyMaskHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.Structure;

public class PropertyMask
extends Structure {
    public static final String NAME_MEMBER = "name";
    public static final String MASK_MEMBER = "mask";
    public static final String STRUCTURE_NAME = "PropertyMask";
    protected String name = null;
    protected String mask = null;

    public String getStructName() {
        return STRUCTURE_NAME;
    }

    protected Object getIntrinsicProperty(String propName) {
        if (NAME_MEMBER.equals(propName)) {
            return this.name;
        }
        if (MASK_MEMBER.equals(propName)) {
            return this.mask;
        }
        assert (false);
        return null;
    }

    protected void setIntrinsicProperty(String propName, Object value) {
        if (NAME_MEMBER.equals(propName)) {
            this.name = (String)value;
        } else if (MASK_MEMBER.equals(propName)) {
            this.mask = (String)value;
        } else assert (false);
    }

    public String getName() {
        return (String)this.getProperty(null, NAME_MEMBER);
    }

    public String getMask() {
        return (String)this.getProperty(null, MASK_MEMBER);
    }

    public StructureHandle handle(SimpleValueHandle valueHandle, int index) {
        return new PropertyMaskHandle(valueHandle, index);
    }

    public void setMask(String mask) {
        this.mask = mask;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List validate(Module module, DesignElement element) {
        ArrayList<SemanticException> list = new ArrayList<SemanticException>();
        if (StringUtil.isBlank(this.getName())) {
            list.add(new PropertyValueException(element, this.getDefn().getMember(NAME_MEMBER), null, "Error.PropertyValueException.VALUE_REQUIRED"));
        } else if (element.getPropertyDefn(this.getName()) == null) {
            list.add(new SemanticError(element, new String[]{this.getName()}, "Error.SemanticError.INVALID_PROPERTY_NAME"));
        }
        return list;
    }
}

