/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import org.eclipse.birt.report.model.api.command.ExtendsException;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.ReferencableStructure;
import org.eclipse.birt.report.model.core.ReferenceableElement;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefPropertyType;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.ReferenceValue;
import org.eclipse.birt.report.model.metadata.StructPropertyDefn;
import org.eclipse.birt.report.model.metadata.StructRefPropertyType;
import org.eclipse.birt.report.model.metadata.StructRefValue;
import org.eclipse.birt.report.model.util.ModelUtil;

public class ReferenceValueUtil {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.util.ReferenceValueUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public static ElementRefValue resolveElementReference(Structure structure, Module module, StructPropertyDefn prop, Object value) {
        if (prop.getTypeCode() != 15) {
            return null;
        }
        if (!$assertionsDisabled && value != null && !(value instanceof ElementRefValue)) {
            throw new AssertionError();
        }
        if (value == null || module == null) {
            return (ElementRefValue)value;
        }
        ElementRefValue ref = (ElementRefValue)value;
        if (ref.isResolved()) {
            return ref;
        }
        ElementRefPropertyType refType = (ElementRefPropertyType)prop.getType();
        refType.resolve(module, prop, ref);
        if (!ref.isResolved()) {
            return ref;
        }
        DesignElement me = structure.getElement();
        if (me instanceof ReferenceableElement && ModelUtil.isRecursiveReference(ref.getElement(), (ReferenceableElement)me)) {
            ref.unresolved(ref.getName());
            return ref;
        }
        ref.getTargetElement().addClient(structure, prop.getName());
        return ref;
    }

    public static String needTheNamespacePrefix(ReferenceValue refValue, Module root, Module module) {
        if (refValue == null) {
            return null;
        }
        String namespace = refValue.getLibraryNamespace();
        String name = refValue.getName();
        if (namespace == null) {
            return name;
        }
        Module theRoot = module;
        if (root != null) {
            theRoot = root;
        }
        if (theRoot instanceof Library) {
            if (!namespace.equals(((Library)theRoot).getNamespace())) {
                name = String.valueOf(namespace) + "." + name;
            }
        } else {
            name = String.valueOf(namespace) + "." + name;
        }
        return name;
    }

    public static String needTheNamespacePrefix(DesignElement element, Module root, Module module) {
        if (element == null) {
            return null;
        }
        String nameSpace = null;
        if (root != null && root instanceof Library) {
            nameSpace = ((Library)root).getNamespace();
        }
        String name = element.getFullName();
        if (root != module) {
            name = String.valueOf(nameSpace) + "." + name;
        }
        return name;
    }

    public static String needTheNamespacePrefix(ReferenceValue refValue, Module root) {
        return ReferenceValueUtil.needTheNamespacePrefix(refValue, root, null);
    }

    public static void resloveExtends(Module module, DesignElement element, ElementRefValue extendsRef) {
        if (extendsRef == null || module == null) {
            return;
        }
        if (extendsRef.isResolved()) {
            return;
        }
        ElementDefn metaData = (ElementDefn)element.getDefn();
        PropertyDefn propDefn = (PropertyDefn)((Object)metaData.getProperty("extends"));
        DesignElement resolvedParent = module.resolveElement(ReferenceValueUtil.needTheNamespacePrefix(extendsRef, module), propDefn, (IElementDefn)metaData);
        try {
            element.checkExtends(resolvedParent);
            if (resolvedParent != null) {
                extendsRef.resolve(resolvedParent);
                resolvedParent.addDerived(element);
            }
        }
        catch (ExtendsException extendsException) {}
    }

    public static ElementRefValue resolveElementReference(Module module, DesignElement element, ElementPropertyDefn prop, ElementRefValue value) {
        ElementRefValue ref = value;
        if (ref.isResolved()) {
            return ref;
        }
        if (!$assertionsDisabled && prop.getTypeCode() != 15 && prop.getSubTypeCode() != 15) {
            throw new AssertionError();
        }
        ElementRefPropertyType refType = null;
        refType = prop.getTypeCode() == 15 ? (ElementRefPropertyType)prop.getType() : (ElementRefPropertyType)prop.getSubType();
        refType.resolve(module, prop, ref);
        if (ref.isResolved()) {
            ref.getTargetElement().addClient(element, prop.getName());
        }
        return ref;
    }

    public static StructRefValue resolveStructReference(Module module, DesignElement element, ElementPropertyDefn prop, StructRefValue value) {
        StructRefValue ref = value;
        if (ref.isResolved()) {
            return ref;
        }
        StructRefPropertyType refType = (StructRefPropertyType)prop.getType();
        refType.resolve(module, prop, ref);
        if (ref.isResolved()) {
            ref.getTargetStructure().addClient(element, prop.getName());
        }
        return ref;
    }

    public static void updateReference(DesignElement element, ReferenceValue oldRef, ReferenceValue newRef, ElementPropertyDefn prop) {
        Object target;
        if (oldRef == null && newRef == null) {
            return;
        }
        if (oldRef instanceof ElementRefValue || newRef instanceof ElementRefValue) {
            if (oldRef != null && (target = ((ElementRefValue)oldRef).getTargetElement()) != null) {
                target.dropClient(element);
            }
            if (newRef != null && (target = ((ElementRefValue)newRef).getTargetElement()) != null) {
                target.addClient(element, prop.getName());
            }
        }
        if (oldRef instanceof StructRefValue || newRef instanceof StructRefValue) {
            if (oldRef != null && (target = ((StructRefValue)oldRef).getTargetStructure()) != null) {
                ((ReferencableStructure)target).dropClient(element);
            }
            if (newRef != null && (target = ((StructRefValue)newRef).getTargetStructure()) != null) {
                ((ReferencableStructure)target).addClient(element, prop.getName());
            }
        }
    }
}

