/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.ISlotDefn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.MetaDataException;
import org.eclipse.birt.report.model.metadata.SemanticTriggerDefnSet;
import org.eclipse.birt.report.model.validators.ISemanticTriggerDefnSetProvider;

public class SlotDefn
implements ISlotDefn,
ISemanticTriggerDefnSetProvider {
    protected int slotID = 0;
    protected boolean multipleCardinality = true;
    protected String name = null;
    protected String displayNameID = null;
    protected ArrayList contentElements = new ArrayList();
    protected ArrayList contentTypes = new ArrayList();
    protected String selector = null;
    protected SemanticTriggerDefnSet triggers = null;
    protected String since;
    protected String xmlName;
    protected boolean isManagedByNameSpace = true;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.metadata.SlotDefn");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public boolean isMultipleCardinality() {
        return this.multipleCardinality;
    }

    void setMultipleCardinality(boolean flag) {
        this.multipleCardinality = flag;
    }

    public String getDisplayName() {
        if (!$assertionsDisabled && this.displayNameID == null) {
            throw new AssertionError();
        }
        return ModelMessages.getMessage(this.displayNameID);
    }

    public String getDisplayNameID() {
        return this.displayNameID;
    }

    void setDisplayNameID(String msgID) {
        this.displayNameID = msgID;
    }

    public int getSlotID() {
        return this.slotID;
    }

    void setSlotID(int id) {
        this.slotID = id;
    }

    public List getContentElements() {
        return new ArrayList(this.contentElements);
    }

    public List getContentExtendedElements() {
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        IElementDefn extendItem = dd.getElement("ExtendedItem");
        ArrayList<ExtensionElementDefn> contentsWithExtensions = new ArrayList<ExtensionElementDefn>();
        contentsWithExtensions.addAll(this.contentElements);
        if (this.contentElements.contains(extendItem)) {
            contentsWithExtensions.remove(extendItem);
            int i = 0;
            while (i < dd.getExtensions().size()) {
                ExtensionElementDefn extension = (ExtensionElementDefn)dd.getExtensions().get(i);
                if (extension.isKindOf(dd.getElement("ReportItem")) && "org.eclipse.birt.report.model.reportItemModel".equals(extension.extensionPoint) && !contentsWithExtensions.contains(extension)) {
                    contentsWithExtensions.add(extension);
                }
                ++i;
            }
        }
        return contentsWithExtensions;
    }

    protected void build() throws MetaDataException {
        if (this.contentTypes.isEmpty()) {
            throw new MetaDataException(new String[]{this.name}, "MISSING_SLOT_TYPE");
        }
        if (this.displayNameID == null) {
            throw new MetaDataException(new String[]{this.name}, "MISSING_SLOT_NAME");
        }
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        this.contentElements.clear();
        Iterator iter = this.contentTypes.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            ElementDefn type = (ElementDefn)dd.getElement(name);
            if (type == null) {
                throw new MetaDataException(new String[]{name, this.name}, "INVALID_SLOT_TYPE");
            }
            this.contentElements.add(type);
        }
        this.getTriggerDefnSet().build();
    }

    public final boolean canContain(IElementDefn type) {
        if (type == null) {
            return false;
        }
        Iterator iter = this.contentElements.iterator();
        while (iter.hasNext()) {
            ExtensionElementDefn extensionDefn;
            ElementDefn element = (ElementDefn)iter.next();
            if (!"ExtendedItem".equals(element.getName())) {
                if (!type.isKindOf(element)) continue;
                return true;
            }
            if (type instanceof ExtensionElementDefn && "org.eclipse.birt.report.model.reportItemModel".equals((extensionDefn = (ExtensionElementDefn)type).getExtensionPoint()) && extensionDefn.isKindOf(MetaDataDictionary.getInstance().getElement("ReportItem"))) {
                return true;
            }
            if (!"ExtendedItem".equals(type.getName())) continue;
            return true;
        }
        return false;
    }

    public final boolean canContain(DesignElement content) {
        return this.canContain(content.getDefn());
    }

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    void addType(String type) {
        if (!this.contentTypes.contains(type)) {
            this.contentTypes.add(type);
        }
    }

    public String getDefaultStyle() {
        return null;
    }

    void setSelector(String value) {
        this.selector = value;
    }

    public String getSelector() {
        return this.selector;
    }

    public SemanticTriggerDefnSet getTriggerDefnSet() {
        if (this.triggers == null) {
            this.triggers = new SemanticTriggerDefnSet();
        }
        return this.triggers;
    }

    public void setSince(String value) {
        this.since = value;
    }

    public String getSince() {
        return this.since;
    }

    public String getXmlName() {
        return this.xmlName;
    }

    public void setXmlName(String value) {
        this.xmlName = value;
    }

    public String toString() {
        if (!StringUtil.isBlank(this.getName())) {
            return this.getName();
        }
        return super.toString();
    }

    public boolean isManagedByNameSpace() {
        return this.isManagedByNameSpace;
    }

    public void setManagedByNameSpace(boolean isManagedByNameSpace) {
        this.isManagedByNameSpace = isManagedByNameSpace;
    }

    public List getAllowedElements() {
        return this.getAllowedElements(true);
    }

    public List getAllowedElements(boolean extractExtensions) {
        if (extractExtensions) {
            return this.getContentExtendedElements();
        }
        return this.getContentElements();
    }
}

