/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.validators.InconsistentColumnsValidator;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.TableColumn;
import org.eclipse.birt.report.model.elements.TableRow;
import org.eclipse.birt.report.model.elements.interfaces.IGridItemModel;

public class GridItem
extends ReportItem
implements IGridItemModel {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.elements.GridItem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public GridItem() {
        this.initSlots();
    }

    public GridItem(String theName) {
        super(theName);
        this.initSlots();
    }

    public void apply(ElementVisitor visitor) {
        visitor.visitGrid(this);
    }

    public String getElementName() {
        return "Grid";
    }

    public DesignElementHandle getHandle(Module module) {
        return this.handle(module);
    }

    public GridHandle handle(Module module) {
        if (this.handle == null) {
            this.handle = new GridHandle(module, this);
        }
        return (GridHandle)this.handle;
    }

    public ContainerSlot getSlot(int slot) {
        if (!($assertionsDisabled || slot >= 0 && slot < 2)) {
            throw new AssertionError();
        }
        return this.slots[slot];
    }

    public int getColumnCount(Module module) {
        int colCount = this.getColDefnCount(module);
        if (colCount != 0) {
            return colCount;
        }
        return this.findMaxCols(module);
    }

    public int getColDefnCount(Module module) {
        int colCount = 0;
        ContainerSlot cols = this.getSlot(0);
        int colDefnCount = cols.getCount();
        int i = 0;
        while (i < colDefnCount) {
            TableColumn col = (TableColumn)cols.getContent(i);
            colCount += col.getIntProperty(module, "repeat");
            ++i;
        }
        return colCount;
    }

    public int findMaxCols(Module module) {
        ContainerSlot rows = this.getSlot(1);
        int maxCols = 0;
        int count = rows.getCount();
        int i = 0;
        while (i < count) {
            TableRow row = (TableRow)rows.getContent(i);
            int cols = row.getColumnCount(module);
            if (cols > maxCols) {
                maxCols = cols;
            }
            ++i;
        }
        return maxCols;
    }

    public int getCellPositionInColumn(Module module, Cell target) {
        int pos = target.getColumn(module);
        if (pos > 0) {
            return pos;
        }
        pos = 1;
        TableRow row = (TableRow)target.getContainer();
        List list = row.getContentsSlot();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Cell cell = (Cell)iter.next();
            int cellPos = cell.getColumn(module);
            if (cellPos > 0) {
                pos = cellPos;
            }
            if (cell == target) {
                return pos;
            }
            pos += cell.getColSpan(module);
        }
        return pos;
    }

    public List validate(Module module) {
        List list = super.validate(module);
        list.addAll(InconsistentColumnsValidator.getInstance().validate(module, this));
        return list;
    }

    public String getDisplayLabel(Module module, int level) {
        String displayLabel = super.getDisplayLabel(module, level);
        if (level == 2) {
            GridHandle handle = this.handle(module);
            int rows = handle.getRows().getCount();
            int cols = handle.getColumns().getCount();
            displayLabel = String.valueOf(displayLabel) + "(" + rows + " x " + cols + ")";
        }
        return displayLabel;
    }
}

