/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core.namespace;

import java.util.List;
import org.eclipse.birt.report.model.api.core.IAccessControl;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.core.namespace.DummyNameContext;
import org.eclipse.birt.report.model.core.namespace.INameContainer;
import org.eclipse.birt.report.model.core.namespace.INameContext;
import org.eclipse.birt.report.model.core.namespace.INameHelper;
import org.eclipse.birt.report.model.core.namespace.NameExecutor;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.util.LevelContentIterator;

public abstract class AbstractNameHelper
implements INameHelper,
IAccessControl {
    protected INameContext[] nameContexts = null;
    protected NameSpace[] cachedNameSpaces = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.core.namespace.AbstractNameHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public AbstractNameHelper() {
        this.initCachedNameSpaces();
    }

    private void initCachedNameSpaces() {
        this.cachedNameSpaces = new NameSpace[this.getNameSpaceCount()];
        int i = 0;
        while (i < this.getNameSpaceCount()) {
            this.cachedNameSpaces[i] = new NameSpace();
            ++i;
        }
    }

    protected abstract void initialize();

    abstract int getNameSpaceCount();

    public INameContext getNameContext(int nameSpaceID) {
        if (nameSpaceID >= 0 && nameSpaceID < this.getNameSpaceCount()) {
            return this.nameContexts[nameSpaceID];
        }
        return new DummyNameContext();
    }

    public void clear() {
        this.initCachedNameSpaces();
    }

    public NameSpace getCachedNameSpace(int id) {
        if (!($assertionsDisabled || id >= 0 && id < 9)) {
            throw new AssertionError();
        }
        return this.cachedNameSpaces[id];
    }

    public void rename(DesignElement element) {
        if (element == null) {
            return;
        }
        ElementDefn defn = (ElementDefn)element.getDefn();
        if (defn.getNameOption() == 2 || element.getRoot() instanceof Library || this.getElement().getRoot() instanceof Library || element.getName() != null) {
            if (this.getElement().getDefn().isKindOf(defn.getNameConfig().getNameContainer())) {
                this.makeUniqueName(element);
            } else {
                INameHelper nameHelper = new NameExecutor(element).getNameHelper(this.getElement().getRoot());
                if (nameHelper != null) {
                    nameHelper.makeUniqueName(element);
                }
            }
        }
        LevelContentIterator iter = new LevelContentIterator(this.getElement().getRoot(), element, 1);
        while (iter.hasNext()) {
            DesignElement innerElement = (DesignElement)iter.next();
            this.rename(innerElement);
        }
    }

    public NameSpace getNameSpace(int nameSpaceID) {
        return this.getNameContext(nameSpaceID).getNameSpace();
    }

    public void makeUniqueName(DesignElement element) {
        if (element == null) {
            return;
        }
        ElementDefn eDefn = (ElementDefn)element.getDefn();
        if (!this.getElement().getDefn().isKindOf(eDefn.getNameConfig().getNameContainer())) {
            INameHelper nameHelper = new NameExecutor(element).getNameHelper(this.getElement().getRoot());
            if (nameHelper != null) {
                nameHelper.makeUniqueName(element);
            }
            return;
        }
        String name = this.getUniqueName(element);
        if (name == null) {
            return;
        }
        NameSpace nameSpace = this.getCachedNameSpace(eDefn.getNameSpaceID());
        DesignElement cachedElement = nameSpace.getElement(name);
        if (cachedElement == null) {
            element.setName(name.trim());
            nameSpace.insert(element);
        }
    }

    public final ElementRefValue resolve(String elementName, PropertyDefn propDefn, IElementDefn elementDefn) {
        ElementDefn targetDefn;
        if (!$assertionsDisabled && !this.isValidReferenceProperty(propDefn)) {
            throw new AssertionError();
        }
        ElementDefn elementDefn2 = targetDefn = propDefn == null ? null : (ElementDefn)propDefn.getTargetElementType();
        if (targetDefn == null) {
            if (!$assertionsDisabled && elementDefn == null) {
                throw new AssertionError();
            }
            targetDefn = (ElementDefn)elementDefn;
        }
        ElementDefn nameContainerDefn = (ElementDefn)targetDefn.getNameConfig().getNameContainer();
        if (!$assertionsDisabled && nameContainerDefn == null) {
            throw new AssertionError();
        }
        if (this.getElement().getDefn().isKindOf(nameContainerDefn)) {
            int id = targetDefn.getNameSpaceID();
            return this.getNameContext(id).resolve(elementName, propDefn);
        }
        return this.resolveName(elementName, propDefn, targetDefn);
    }

    public final ElementRefValue resolve(DesignElement element, PropertyDefn propDefn, IElementDefn elementDefn) {
        ElementDefn targetDefn;
        if (element == null) {
            return null;
        }
        if (!this.isValidReferenceProperty(propDefn)) {
            throw new IllegalArgumentException("Property should be element reference type or extends type");
        }
        ElementDefn elementDefn2 = targetDefn = propDefn == null ? null : (ElementDefn)propDefn.getTargetElementType();
        if (targetDefn == null) {
            if (elementDefn == null) {
                throw new IllegalArgumentException("The element definition should not be null");
            }
            targetDefn = (ElementDefn)elementDefn;
        }
        if (!element.getDefn().isKindOf(targetDefn)) {
            Module module = element.getRoot();
            String namespace = module == null ? null : module.getNamespace();
            String name = element.getFullName();
            return new ElementRefValue(namespace, name);
        }
        ElementDefn nameContainerDefn = (ElementDefn)targetDefn.getNameConfig().getNameContainer();
        if (!$assertionsDisabled && nameContainerDefn == null) {
            throw new AssertionError();
        }
        if (this.getElement().getDefn().isKindOf(nameContainerDefn)) {
            int id = targetDefn.getNameSpaceID();
            return this.getNameContext(id).resolve(element, propDefn);
        }
        return this.resolveElement(element, propDefn, targetDefn);
    }

    public boolean canContain(int nameSpaceID, String elementName) {
        return this.getNameContext(nameSpaceID).canContain(elementName);
    }

    public List getElements(int nameSpaceID, int level) {
        return this.getNameContext(nameSpaceID).getElements(level);
    }

    private NameResolveInfor getRootResolveInfor(String elementName, ElementDefn targetDefn) {
        NameResolveInfor searchInfor = new NameResolveInfor(targetDefn, elementName);
        IElementDefn moduleDefn = MetaDataDictionary.getInstance().getElement("Module");
        while (searchInfor != null) {
            ElementDefn holderDefn = (ElementDefn)searchInfor.elementDefn.getNameConfig().getNameContainer();
            if (holderDefn != null && holderDefn.isKindOf(moduleDefn)) {
                return searchInfor;
            }
            int index = searchInfor.elementName.lastIndexOf("/");
            String resolveName = index == -1 ? searchInfor.elementName : searchInfor.elementName.substring(0, index);
            targetDefn = searchInfor.elementDefn;
            NameResolveInfor nameResolveInfor = searchInfor = holderDefn == null ? null : new NameResolveInfor(holderDefn, resolveName);
        }
        return null;
    }

    private ElementRefValue resolveElement(DesignElement element, PropertyDefn propDefn, IElementDefn elementDefn) {
        if (!$assertionsDisabled && element == null) {
            throw new AssertionError();
        }
        INameHelper nameHelper = new NameExecutor(element).getNameHelper(this.getElement().getRoot());
        return nameHelper == null ? null : nameHelper.resolve(element, propDefn, elementDefn);
    }

    private ElementRefValue resolveName(String elementName, PropertyDefn propDefn, ElementDefn elementDefn) {
        NameResolveInfor rootInfor;
        if (!$assertionsDisabled && elementName == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && elementDefn == null) {
            throw new AssertionError();
        }
        Module root = this.getElement().getRoot();
        if (root != null && (rootInfor = this.getRootResolveInfor(elementName, elementDefn)) != null) {
            int id = rootInfor.elementDefn.getNameSpaceID();
            AbstractNameHelper nameHelper = (AbstractNameHelper)root.getNameHelper();
            DesignElement parentTarget = nameHelper.getNameContext(id).findElement(rootInfor.elementName, rootInfor.elementDefn);
            if (parentTarget != null) {
                if (!$assertionsDisabled && !(parentTarget instanceof INameContainer)) {
                    throw new AssertionError();
                }
                return ((INameContainer)((Object)parentTarget)).getNameHelper().resolve(elementName, propDefn, (IElementDefn)elementDefn);
            }
        }
        return new ElementRefValue(StringUtil.extractNamespace(elementName), StringUtil.extractName(elementName));
    }

    private boolean isValidReferenceProperty(PropertyDefn propDefn) {
        if (propDefn == null) {
            return true;
        }
        int typeCode = propDefn.getTypeCode();
        switch (typeCode) {
            case 15: 
            case 17: {
                return true;
            }
            case 20: {
                return propDefn.getSubTypeCode() == 15;
            }
        }
        return false;
    }

    protected static boolean isValidInNameSpace(NameSpace namespace, DesignElement element, String name) {
        DesignElement tmpElement = namespace.getElement(name);
        return tmpElement == null || tmpElement == element;
    }

    class NameResolveInfor {
        ElementDefn elementDefn = null;
        String elementName = null;

        NameResolveInfor(ElementDefn defn, String name) {
            this.elementDefn = defn;
            this.elementName = name;
        }
    }
}

