/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.ScalarParameter;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;

public class PropertySearchStrategy {
    private static final PropertySearchStrategy instance;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.core.PropertySearchStrategy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        instance = new PropertySearchStrategy();
    }

    protected PropertySearchStrategy() {
    }

    public static PropertySearchStrategy getInstance() {
        return instance;
    }

    public Object getPropertyExceptRomDefault(Module module, DesignElement element, ElementPropertyDefn prop) {
        if (prop.isIntrinsic()) {
            return element.getIntrinsicProperty(prop.getName());
        }
        DesignElement e = element;
        Object value = null;
        while (e != null) {
            PropertySearchStrategy tmpStrategy = e.getStrategy();
            value = tmpStrategy.getNonIntrinsicPropertyFromElement(module, e, prop);
            if (value != null) {
                return value;
            }
            if (!prop.isStyleProperty() || e.isStyle() || !tmpStrategy.isInheritableProperty(e, prop)) break;
            e = e.getContainer();
        }
        return this.getSessionDefaultValue(module, prop);
    }

    public final Object getPropertyFromElement(Module module, DesignElement element, ElementPropertyDefn prop) {
        if (prop.isIntrinsic()) {
            return element.getIntrinsicProperty(prop.getName());
        }
        return this.getNonIntrinsicPropertyFromElement(module, element, prop);
    }

    private Object getNonIntrinsicPropertyFromElement(Module module, DesignElement element, ElementPropertyDefn prop) {
        if (!$assertionsDisabled && prop.isIntrinsic()) {
            throw new AssertionError();
        }
        Object value = null;
        value = this.getPropertyFromSelf(module, element, prop);
        if (value != null) {
            return value;
        }
        if ((this.isInheritableProperty(element, prop) || prop.isStyleProperty()) && (value = this.getPropertyFromParent(element, prop)) != null) {
            return value;
        }
        if (module == null) {
            return null;
        }
        if (prop.isStyleProperty()) {
            value = this.getPropertyFromSelfSelector(module, element, prop);
            if (value != null) {
                return value;
            }
            value = this.getPropertyFromSlotSelector(module, element, prop);
            if (value != null) {
                return value;
            }
            value = this.getPropertyRelatedToContainer(module, element, prop);
            if (value != null) {
                return value;
            }
        }
        return null;
    }

    protected Object getPropertyFromSelf(Module module, DesignElement element, ElementPropertyDefn prop) {
        Object value = element.getLocalProperty(module, prop);
        if (value != null) {
            return value;
        }
        StyleElement style = element.getStyle(module);
        if (style != null && (value = style.getLocalProperty(module, prop)) != null) {
            return value;
        }
        return null;
    }

    protected Object getPropertyFromParent(DesignElement element, ElementPropertyDefn prop) {
        Object value = null;
        DesignElement e = element;
        do {
            if ((e = e.isVirtualElement() ? e.getVirtualParent() : e.getExtendsElement()) == null) continue;
            Module currentRoot = e.getRoot();
            if (!$assertionsDisabled && currentRoot == null) {
                throw new AssertionError();
            }
            value = this.getPropertyFromSelf(currentRoot, e, prop);
            if (value == null) continue;
            return value;
        } while (e != null);
        return value;
    }

    protected Object getPropertyFromSelfSelector(Module module, DesignElement element, ElementPropertyDefn prop) {
        String selector = ((ElementDefn)element.getDefn()).getSelector();
        return this.getPropertyFromSelector(module, prop, selector);
    }

    protected Object getPropertyFromSlotSelector(Module module, DesignElement element, ElementPropertyDefn prop) {
        if (element.getContainer() == null) {
            return null;
        }
        String selector = element.getContainerInfo().getSelector();
        return this.getPropertyFromSelector(module, prop, selector);
    }

    protected Object getPropertyFromSelector(Module module, ElementPropertyDefn prop, String selector) {
        if (!$assertionsDisabled && module == null) {
            throw new AssertionError();
        }
        if (selector == null) {
            return null;
        }
        StyleElement style = module.findStyle(selector);
        if (style != null) {
            return style.getLocalProperty(module, prop);
        }
        return null;
    }

    protected Object getPropertyRelatedToContainer(Module module, DesignElement element, ElementPropertyDefn prop) {
        return null;
    }

    protected Object getSessionDefaultValue(Module module, ElementPropertyDefn prop) {
        if (prop.isStyleProperty()) {
            return module.getSession().getDefaultValue(prop.getName());
        }
        return null;
    }

    protected boolean isInheritableProperty(DesignElement element, ElementPropertyDefn prop) {
        if (!$assertionsDisabled && prop == null) {
            throw new AssertionError();
        }
        boolean inherit = prop.canInherit();
        if (!inherit) {
            return false;
        }
        if (element instanceof ReportItem ? "boundDataColumns".equals(prop.getName()) && element.getLocalProperty(element.getRoot(), "dataSet") != null : element instanceof ScalarParameter && "boundDataColumns".equals(prop.getName()) && element.getLocalProperty(element.getRoot(), "dataSetName") != null) {
            return false;
        }
        return inherit;
    }
}

