/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.activity.LayoutRecordTask;
import org.eclipse.birt.report.model.activity.SimpleRecord;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.ExtensionPropertyDefinitionEvent;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.api.elements.table.LayoutUtil;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.core.StructureContext;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.birt.report.model.validators.ValidationExecutor;

public class PropertyRecord
extends SimpleRecord {
    private DesignElement element = null;
    private ElementPropertyDefn propDefn = null;
    private Object oldValue = null;
    private Object newValue = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.command.PropertyRecord");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public PropertyRecord(DesignElement propertyOwner, String name, Object value) {
        if (!$assertionsDisabled && propertyOwner == null) {
            throw new AssertionError();
        }
        this.element = propertyOwner;
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        this.propDefn = this.element.getPropertyDefn(name);
        if (!$assertionsDisabled && this.propDefn == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.propDefn.isIntrinsic()) {
            throw new AssertionError();
        }
        this.newValue = value;
        this.oldValue = this.copyLocalValue(propertyOwner.getLocalProperty(null, this.propDefn));
        this.label = ModelMessages.getMessage("Message.ChangeProperty", new String[]{this.propDefn.getDisplayName()});
    }

    public PropertyRecord(DesignElement propertyOwner, ElementPropertyDefn prop, Object value) {
        if (!$assertionsDisabled && propertyOwner == null) {
            throw new AssertionError();
        }
        this.propDefn = prop;
        if (!$assertionsDisabled && this.propDefn == null) {
            throw new AssertionError();
        }
        this.element = propertyOwner;
        this.newValue = value;
        this.oldValue = this.copyLocalValue(propertyOwner.getLocalProperty(null, this.propDefn));
        this.label = ModelMessages.getMessage("Message.ChangeProperty", new String[]{this.propDefn.getDisplayName()});
    }

    private Object copyLocalValue(Object localValue) {
        if (localValue instanceof List) {
            ArrayList newValue = new ArrayList();
            newValue.addAll((List)localValue);
            return newValue;
        }
        return localValue;
    }

    public DesignElement getTarget() {
        if (this.eventTarget != null) {
            return this.eventTarget.getElement();
        }
        return this.element;
    }

    public NotificationEvent getEvent() {
        IReportItem extElement;
        if (this.element instanceof ExtendedItem && (extElement = ((ExtendedItem)this.element).getExtendedElement()) != null && extElement.refreshPropertyDefinition()) {
            return new ExtensionPropertyDefinitionEvent(this.element);
        }
        if (this.eventTarget != null) {
            return new PropertyEvent(this.eventTarget.getElement(), this.eventTarget.getPropName());
        }
        return new PropertyEvent(this.element, this.propDefn.getName());
    }

    protected void perform(boolean undo) {
        Object value = null;
        Object tmpOldValue = null;
        if (!undo) {
            value = this.newValue;
            tmpOldValue = this.oldValue;
        } else {
            value = this.oldValue;
            tmpOldValue = this.newValue;
        }
        if (this.propDefn.getTypeCode() != 16) {
            if (this.propDefn.isEncryptable() && value instanceof String) {
                String encryption;
                String localEncryption = this.element.getLocalEncryptionID(this.propDefn);
                String string = encryption = localEncryption == null ? this.element.getEncryptionID(this.propDefn) : localEncryption;
                if (!$assertionsDisabled && encryption == null) {
                    throw new AssertionError();
                }
                value = ModelUtil.encryptProperty(this.element, this.propDefn, encryption, value);
                this.element.setProperty(this.propDefn, value);
                if (localEncryption == null) {
                    this.element.setEncryptionHelper(this.propDefn, encryption);
                }
                return;
            }
            this.element.setProperty(this.propDefn, value);
            return;
        }
        this.clearStructureContext(tmpOldValue);
        this.setupStructureContext(value);
        if (value == null || value instanceof List && ((List)value).isEmpty()) {
            this.element.setProperty(this.propDefn, value);
        }
    }

    private void setupStructureContext(Object values) {
        if (values == null) {
            return;
        }
        if (values instanceof List && ((List)values).isEmpty()) {
            return;
        }
        StructureContext context = new StructureContext(this.element, this.propDefn.getName());
        if (values instanceof Structure) {
            context.add((Structure)values);
        } else if (values instanceof List) {
            int i = 0;
            while (i < ((List)values).size()) {
                context.add((Structure)((List)values).get(i));
                ++i;
            }
        }
    }

    private void clearStructureContext(Object values) {
        if (values == null) {
            return;
        }
        if (values instanceof List && ((List)values).isEmpty()) {
            return;
        }
        StructureContext context = new StructureContext(this.element, this.propDefn.getName());
        if (values instanceof Structure) {
            context.remove((Structure)values);
        } else if (values instanceof List) {
            int count = ((List)values).size();
            int i = 0;
            while (i < count) {
                context.remove(0);
                ++i;
            }
        }
    }

    public List getValidators() {
        return ValidationExecutor.getValidationNodes(this.element, this.propDefn.getTriggerDefnSet(), false);
    }

    public ElementPropertyDefn getPropDefn() {
        return this.propDefn;
    }

    protected List getPostTasks() {
        ArrayList<LayoutRecordTask> retValue = new ArrayList<LayoutRecordTask>();
        retValue.addAll(super.getPostTasks());
        if (!(this.element instanceof Cell)) {
            return retValue;
        }
        String propName = this.propDefn.getName();
        if (!("colSpan".equalsIgnoreCase(propName) || "rowSpan".equalsIgnoreCase(propName) || "column".equalsIgnoreCase(propName) || "drop".equalsIgnoreCase(propName))) {
            return retValue;
        }
        ReportItem compoundElement = LayoutUtil.getCompoundContainer(this.element);
        if (compoundElement == null) {
            return retValue;
        }
        retValue.add(new LayoutRecordTask(compoundElement.getRoot(), compoundElement));
        return retValue;
    }
}

