/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.IncludedCssStyleSheetHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.css.CssStyleSheet;
import org.eclipse.birt.report.model.css.CssStyleSheetHandleAdapter;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.elements.interfaces.IThemeModel;

public class ThemeHandle
extends ReportElementHandle
implements IThemeModel {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.api.ThemeHandle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public ThemeHandle(Module module, DesignElement element) {
        super(module, element);
    }

    public SlotHandle getStyles() {
        return this.getSlot(0);
    }

    public List getAllStyles() {
        Theme theme = (Theme)this.getElement();
        ArrayList<DesignElementHandle> styles = new ArrayList<DesignElementHandle>();
        List styleList = theme.getAllStyles();
        Iterator iter = styleList.iterator();
        while (iter.hasNext()) {
            StyleElement style = (StyleElement)iter.next();
            styles.add(style.getHandle(this.module));
        }
        return styles;
    }

    public List getAllCssStyleSheets() {
        Theme theme = (Theme)this.getElement();
        ArrayList<CssStyleSheetHandle> allStyles = new ArrayList<CssStyleSheetHandle>();
        List csses = theme.getCsses();
        int i = 0;
        while (csses != null && i < csses.size()) {
            CssStyleSheet sheet = (CssStyleSheet)csses.get(i);
            allStyles.add(sheet.handle(this.getModule()));
            ++i;
        }
        return allStyles;
    }

    public StyleHandle findStyle(String name) {
        Theme theme = (Theme)this.getElement();
        StyleElement style = theme.findStyle(name);
        if (style != null) {
            return (StyleHandle)style.getHandle(this.module);
        }
        return null;
    }

    String makeUniqueStyleName(String name) {
        if (!$assertionsDisabled && this == null) {
            throw new AssertionError();
        }
        SlotHandle styles = this.getStyles();
        HashSet<String> set = new HashSet<String>();
        int i = 0;
        while (i < styles.getCount()) {
            StyleHandle style = (StyleHandle)styles.get(i);
            set.add(style.getName());
            ++i;
        }
        PropertyHandle propHandle = this.getPropertyHandle("cssStyleSheets");
        Iterator iterator = propHandle.iterator();
        while (iterator.hasNext()) {
            IncludedCssStyleSheetHandle handle = (IncludedCssStyleSheetHandle)iterator.next();
            set.add(handle.getFileName());
        }
        int index = 0;
        String baseName = name;
        while (set.contains(name)) {
            name = String.valueOf(baseName) + ++index;
        }
        return name;
    }

    public String getDisplayLabel(int level) {
        String displayLabel = super.getDisplayLabel(level);
        Module rootModule = this.getModule();
        if (rootModule instanceof Library) {
            displayLabel = StringUtil.buildQualifiedReference(((Library)rootModule).getNamespace(), displayLabel);
        }
        return displayLabel;
    }

    public Iterator includeCssesIterator() {
        PropertyHandle propHandle = this.getPropertyHandle("cssStyleSheets");
        if (!$assertionsDisabled && propHandle == null) {
            throw new AssertionError();
        }
        return propHandle.iterator();
    }

    public void addCss(CssStyleSheetHandle sheetHandle) throws SemanticException {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        adapter.addCss(sheetHandle);
    }

    public void addCss(String fileName) throws SemanticException {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        adapter.addCss(fileName);
    }

    public void dropCss(CssStyleSheetHandle sheetHandle) throws SemanticException {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        adapter.dropCss(sheetHandle);
    }

    public boolean canDropCssStyleSheet(CssStyleSheetHandle sheetHandle) {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        return adapter.canDropCssStyleSheet(sheetHandle);
    }

    public boolean canAddCssStyleSheet(CssStyleSheetHandle sheetHandle) {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        return adapter.canAddCssStyleSheet(sheetHandle);
    }

    public boolean canAddCssStyleSheet(String fileName) {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        return adapter.canAddCssStyleSheet(fileName);
    }

    public void reloadCss(CssStyleSheetHandle sheetHandle) throws SemanticException {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        adapter.reloadCss(sheetHandle);
    }
}

