/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.List;
import org.eclipse.birt.report.model.api.CellContextInfo;
import org.eclipse.birt.report.model.api.ColumnBandAdapter;
import org.eclipse.birt.report.model.api.ColumnBandCopyAction;
import org.eclipse.birt.report.model.api.ColumnBandData;
import org.eclipse.birt.report.model.api.TableColumnBandAdapter;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.elements.TableColumn;

class ColumnBandInsertPasteAction
extends ColumnBandCopyAction {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.api.ColumnBandInsertPasteAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public ColumnBandInsertPasteAction(ColumnBandAdapter adapter) {
        super(adapter);
    }

    protected boolean canInsertAndPaste(int columnIndex, ColumnBandData data) {
        if (this.adapter.hasParent()) {
            return false;
        }
        int columnCount = this.adapter.getColumnCount();
        int targetColumnIndex = columnIndex + 1;
        List originalCells = null;
        if (targetColumnIndex > columnCount) {
            originalCells = this.getCellsContextInfo(this.adapter.getCellsUnderColumn(1));
        } else {
            originalCells = this.getCellsContextInfo(this.adapter.getCellsUnderColumn(targetColumnIndex));
            if (!this.isValidInsertAndPasteArea(originalCells)) {
                return false;
            }
        }
        List cells = data.getCells();
        try {
            this.isSameLayout(cells, originalCells);
        }
        catch (SemanticException semanticException) {
            return false;
        }
        return true;
    }

    protected List insertAndPasteColumnBand(int columnIndex, ColumnBandData data) throws SemanticException {
        boolean canDone = this.canInsertAndPaste(columnIndex, data);
        if (!canDone) {
            throw new SemanticError(this.adapter.getElementHandle().getElement(), new String[]{this.adapter.getElementHandle().getName()}, "Error.SemanticError.COLUMN_PASTE_FORBIDDEN");
        }
        TableColumn column = data.getColumn();
        List cells = data.getCells();
        List originalCells = this.getCellsContextInfo(this.adapter.getCellsUnderColumn(columnIndex));
        try {
            if (this.adapter instanceof TableColumnBandAdapter) {
                this.adapter.getModule().getActivityStack().startSilentTrans();
            } else {
                this.adapter.getModule().getActivityStack().startTrans();
            }
            this.pasteColumn(column, columnIndex, true);
            this.pasteCells(cells, originalCells, columnIndex, true);
        }
        catch (SemanticException e) {
            this.adapter.getModule().getActivityStack().rollback();
            throw e;
        }
        this.adapter.getModule().getActivityStack().commit();
        return this.doPostPasteCheck(column, cells);
    }

    private boolean isValidInsertAndPasteArea(List cells) {
        int numOfRows = this.adapter.getRowCount();
        int rowCount = 0;
        int i = 0;
        while (i < cells.size()) {
            CellContextInfo contextInfo = (CellContextInfo)cells.get(i);
            rowCount += contextInfo.getRowSpan();
            ++i;
        }
        if (!$assertionsDisabled && rowCount > numOfRows) {
            throw new AssertionError();
        }
        return rowCount >= numOfRows;
    }
}

