/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.layout.impl;

import org.eclipse.birt.chart.computation.BoundingBox;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.impl.LabelImpl;
import org.eclipse.birt.chart.model.layout.Block;
import org.eclipse.birt.chart.model.layout.LayoutFactory;
import org.eclipse.birt.chart.model.layout.LayoutPackage;
import org.eclipse.birt.chart.model.layout.TitleBlock;
import org.eclipse.birt.chart.model.layout.impl.LabelBlockImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public class TitleBlockImpl
extends LabelBlockImpl
implements TitleBlock {
    protected TitleBlockImpl() {
    }

    public boolean isTitle() {
        return true;
    }

    public boolean isCustom() {
        return false;
    }

    protected EClass eStaticClass() {
        return LayoutPackage.Literals.TITLE_BLOCK;
    }

    public static Block create() {
        TitleBlock tb = LayoutFactory.eINSTANCE.createTitleBlock();
        ((TitleBlockImpl)tb).initialize();
        return tb;
    }

    protected BoundingBox computeBox(IDisplayServer xs, RunTimeContext rtc) throws ChartException {
        Label la = LabelImpl.copyInstance(this.getLabel());
        String sPreviousValue = la.getCaption().getValue();
        la.getCaption().setValue(rtc.externalizedMessage(sPreviousValue));
        double dWrapping = 0.0;
        EObject container = this.eContainer();
        if (container instanceof Block) {
            dWrapping = ((Block)container).getBounds().getWidth() / 72.0 * (double)xs.getDpiResolution();
        }
        try {
            return Methods.computeBox(xs, 4, la, 0.0, 0.0, dWrapping);
        }
        catch (IllegalArgumentException uiex) {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, uiex);
        }
    }
}

