/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.internal.log;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import org.eclipse.birt.chart.log.ILogger;

public class JavaUtilLoggerImpl
implements ILogger {
    private Logger logger;
    private Level javaLevel = Level.WARNING;
    private static StreamHandler fileHandler = null;

    public JavaUtilLoggerImpl(String name) {
        this.logger = Logger.getLogger(name);
        if (fileHandler != null) {
            this.logger.addHandler(fileHandler);
            this.logger.setUseParentHandlers(false);
        }
        if (this.logger.getLevel() == null) {
            this.logger.setLevel(this.javaLevel);
        }
    }

    public JavaUtilLoggerImpl(String name, int verboseLevel) {
        this.logger = Logger.getLogger(name);
        this.setVerboseLevel(verboseLevel);
    }

    public Logger getJavaLogger() {
        return this.logger;
    }

    public void setVerboseLevel(int iVerboseLevel) {
        this.javaLevel = JavaUtilLoggerImpl.toJavaUtilLevel(iVerboseLevel);
        this.logger.setLevel(this.javaLevel);
    }

    public void log(int iCode, String sMessage) {
        Level level = JavaUtilLoggerImpl.toJavaUtilLevel(iCode);
        if (this.logger.isLoggable(level)) {
            LogRecord lr = new LogRecord(level, sMessage);
            String[] rt = this.inferCaller();
            lr.setSourceClassName(rt[0]);
            lr.setSourceMethodName(rt[1]);
            this.logger.log(lr);
        }
    }

    public void log(Exception ex) {
        if (this.logger.isLoggable(Level.WARNING)) {
            LogRecord lr = new LogRecord(Level.WARNING, "Exception");
            lr.setThrown(ex);
            String[] rt = this.inferCaller();
            lr.setSourceClassName(rt[0]);
            lr.setSourceMethodName(rt[1]);
            this.logger.log(lr);
        }
    }

    private String[] inferCaller() {
        String cname;
        StackTraceElement frame;
        String[] rt = new String[]{this.getClass().getName(), "log"};
        StackTraceElement[] stack = new Throwable().getStackTrace();
        int ix = 0;
        while (ix < stack.length) {
            frame = stack[ix];
            cname = frame.getClassName();
            if (cname.equals(this.getClass().getName())) break;
            ++ix;
        }
        while (ix < stack.length) {
            frame = stack[ix];
            cname = frame.getClassName();
            if (!cname.equals(this.getClass().getName())) {
                rt[0] = cname;
                rt[1] = frame.getMethodName();
                return rt;
            }
            ++ix;
        }
        return rt;
    }

    private static Level toJavaUtilLevel(int chartLevel) {
        if (chartLevel <= -1) {
            return Level.ALL;
        }
        if (chartLevel <= 0) {
            return Level.FINER;
        }
        if (chartLevel <= 1) {
            return Level.INFO;
        }
        if (chartLevel <= 2) {
            return Level.WARNING;
        }
        return Level.SEVERE;
    }

    public static void initFileHandler(String sLogFolder) throws SecurityException, IOException {
        block4: {
            if (sLogFolder.length() > 0 && sLogFolder.lastIndexOf(File.separator) == sLogFolder.length() - 1) {
                sLogFolder = sLogFolder.substring(0, sLogFolder.length() - 1);
            }
            final String sName = "org.eclipse.birt.chart.engine" + new SimpleDateFormat("_yyyy_MM_dd_HH_mm_ss_SSS").format(new Date());
            final String sDir = sLogFolder;
            try {
                fileHandler = AccessController.doPrivileged(new PrivilegedExceptionAction<FileHandler>(){

                    @Override
                    public FileHandler run() throws IOException, SecurityException {
                        FileHandler fileHandler = new FileHandler(String.valueOf(sDir) + File.separator + sName + ".log", true);
                        fileHandler.setFormatter(new SimpleFormatter());
                        fileHandler.setLevel(Level.FINEST);
                        return fileHandler;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception typedException = e.getException();
                if (typedException instanceof IOException) {
                    throw (IOException)typedException;
                }
                if (!(typedException instanceof SecurityException)) break block4;
                throw (SecurityException)typedException;
            }
        }
    }
}

