/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.event;

import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.LegendItemHints;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.StructureType;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.CurveFitting;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.layout.Legend;

public class WrappedStructureSource
extends StructureSource {
    private StructureSource parent = null;

    public WrappedStructureSource(Object source) {
        super(source);
    }

    public WrappedStructureSource(Object source, StructureType type) {
        super(source, type);
    }

    public WrappedStructureSource(StructureSource parent, Object source, StructureType type) {
        super(source, type);
        this.parent = parent;
    }

    public WrappedStructureSource(Object parentSource, StructureType parentType, Object source, StructureType type) {
        super(source, type);
        this.parent = new StructureSource(parentSource, parentType);
    }

    public StructureSource getParent() {
        return this.parent;
    }

    public static StructureSource createLegendTitle(Legend lg, Label title) {
        return new WrappedStructureSource(lg, StructureType.LEGEND, title, StructureType.LEGEND_TITLE);
    }

    public static StructureSource createLegendEntry(Legend lg, LegendItemHints entry) {
        return new WrappedStructureSource(lg, StructureType.LEGEND, entry, StructureType.LEGEND_ENTRY);
    }

    public static StructureSource createAxisTitle(Axis ax, Label title) {
        return new WrappedStructureSource(ax, StructureType.AXIS, title, StructureType.AXIS_TITLE);
    }

    public static StructureSource createAxisLabel(Axis ax, Label lb) {
        return new WrappedStructureSource(ax, StructureType.AXIS, lb, StructureType.AXIS_LABEL);
    }

    public static StructureSource createSeriesDataPoint(Series se, DataPointHints dph) {
        return new WrappedStructureSource(se, StructureType.SERIES, dph, StructureType.SERIES_DATA_POINT);
    }

    public static StructureSource createSeriesDataElement(Series se, DataPointHints dph) {
        return new WrappedStructureSource(se, StructureType.SERIES, dph, StructureType.SERIES_ELEMENT);
    }

    public static StructureSource createSeriesTitle(Series se, Label title) {
        return new WrappedStructureSource(se, StructureType.SERIES, title, StructureType.SERIES_TITLE);
    }

    public static StructureSource createSeriesMarker(Series se, Marker mk) {
        return new WrappedStructureSource(se, StructureType.SERIES, mk, StructureType.SERIES_MARKER);
    }

    public static StructureSource createSeriesFittingCurve(Series se, CurveFitting cf) {
        return new WrappedStructureSource(se, StructureType.SERIES, cf, StructureType.SERIES_FITTING_CURVE);
    }
}

