/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.style;

import java.util.Iterator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.Image;
import org.eclipse.birt.chart.model.attribute.Style;
import org.eclipse.birt.chart.model.attribute.StyleMap;
import org.eclipse.birt.chart.model.attribute.StyledComponent;
import org.eclipse.birt.chart.model.attribute.TextAlignment;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.FontDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.InsetsImpl;
import org.eclipse.birt.chart.model.attribute.impl.TextAlignmentImpl;
import org.eclipse.birt.chart.style.IStyle;
import org.eclipse.birt.chart.style.IStyleProcessor;
import org.eclipse.birt.chart.style.SimpleStyle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public final class SimpleProcessor
implements IStyleProcessor {
    private static final SimpleStyle defaultStyle;
    private static SimpleProcessor instance;

    static {
        TextAlignment ta = TextAlignmentImpl.create();
        FontDefinition font = FontDefinitionImpl.create("SansSerif", 12.0f, false, false, false, false, false, 0.0, ta);
        defaultStyle = new SimpleStyle(font, ColorDefinitionImpl.BLACK(), null, null, null);
    }

    public static synchronized SimpleProcessor instance() {
        if (instance == null) {
            instance = new SimpleProcessor();
        }
        return instance;
    }

    private SimpleProcessor() {
    }

    public IStyle getStyle(Chart model, StyledComponent name) {
        if (model != null && model.getStyles().size() > 0) {
            Iterator itr = model.getStyles().iterator();
            while (itr.hasNext()) {
                StyleMap sm = (StyleMap)itr.next();
                if (!((Object)((Object)sm.getComponentName())).equals((Object)name)) continue;
                Style ss = sm.getStyle();
                SimpleStyle rt = new SimpleStyle(defaultStyle);
                if (ss.getFont() != null) {
                    rt.setFont(FontDefinitionImpl.copyInstance(ss.getFont()));
                }
                if (ss.getColor() != null) {
                    rt.setColor(ColorDefinitionImpl.copyInstance(ss.getColor()));
                }
                if (ss.getBackgroundColor() != null) {
                    rt.setBackgroundColor(ColorDefinitionImpl.copyInstance(ss.getBackgroundColor()));
                }
                if (ss.getBackgroundImage() != null) {
                    rt.setBackgroundImage((Image)EcoreUtil.copy((EObject)ss.getBackgroundImage()));
                }
                if (ss.getPadding() != null) {
                    rt.setPadding(InsetsImpl.copyInstance(ss.getPadding()));
                }
                return rt;
            }
        }
        return defaultStyle.copy();
    }
}

