/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angus.mail.gimap;

import jakarta.mail.FolderClosedException;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import org.eclipse.angus.mail.gimap.protocol.GmailProtocol;
import org.eclipse.angus.mail.iap.ConnectionException;
import org.eclipse.angus.mail.iap.ProtocolException;
import org.eclipse.angus.mail.imap.IMAPFolder;
import org.eclipse.angus.mail.imap.IMAPMessage;
import org.eclipse.angus.mail.imap.protocol.IMAPProtocol;

public class GmailMessage
extends IMAPMessage {
    protected GmailMessage(IMAPFolder folder, int msgnum) {
        super(folder, msgnum);
    }

    protected GmailMessage(Session session) {
        super(session);
    }

    public long getMsgId() throws MessagingException {
        Long msgid = (Long)this.getItem(GmailProtocol.MSGID_ITEM);
        if (msgid != null) {
            return msgid;
        }
        return -1L;
    }

    public long getThrId() throws MessagingException {
        Long thrid = (Long)this.getItem(GmailProtocol.THRID_ITEM);
        if (thrid != null) {
            return thrid;
        }
        return -1L;
    }

    public String[] getLabels() throws MessagingException {
        String[] labels = (String[])this.getItem(GmailProtocol.LABELS_ITEM);
        if (labels != null) {
            return (String[])labels.clone();
        }
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setLabels(String[] labels, boolean set) throws MessagingException {
        Object object = this.getMessageCacheLock();
        synchronized (object) {
            try {
                IMAPProtocol ip = this.getProtocol();
                assert (ip instanceof GmailProtocol);
                GmailProtocol p = (GmailProtocol)ip;
                this.checkExpunged();
                p.storeLabels(this.getSequenceNumber(), labels, set);
            }
            catch (ConnectionException cex) {
                throw new FolderClosedException(this.folder, cex.getMessage());
            }
            catch (ProtocolException pex) {
                throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
            }
        }
    }

    public synchronized void clearCachedLabels() {
        if (this.items != null) {
            this.items.remove(GmailProtocol.LABELS_ITEM.getName());
        }
    }
}

