/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angus.mail.gimap;

import jakarta.mail.FetchProfile;
import jakarta.mail.Folder;
import jakarta.mail.FolderClosedException;
import jakarta.mail.Message;
import jakarta.mail.MessageRemovedException;
import jakarta.mail.MessagingException;
import org.eclipse.angus.mail.gimap.GmailMessage;
import org.eclipse.angus.mail.gimap.protocol.GmailProtocol;
import org.eclipse.angus.mail.iap.ConnectionException;
import org.eclipse.angus.mail.iap.ProtocolException;
import org.eclipse.angus.mail.imap.IMAPFolder;
import org.eclipse.angus.mail.imap.IMAPMessage;
import org.eclipse.angus.mail.imap.IMAPStore;
import org.eclipse.angus.mail.imap.Utility;
import org.eclipse.angus.mail.imap.protocol.IMAPProtocol;
import org.eclipse.angus.mail.imap.protocol.ListInfo;
import org.eclipse.angus.mail.imap.protocol.MessageSet;

public class GmailFolder
extends IMAPFolder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setLabels(Message[] msgs, String[] labels, boolean set) throws MessagingException {
        this.checkOpened();
        if (msgs.length == 0) {
            return;
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                IMAPProtocol ip = this.getProtocol();
                assert (ip instanceof GmailProtocol);
                GmailProtocol p = (GmailProtocol)ip;
                MessageSet[] ms = Utility.toMessageSetSorted((Message[])msgs, null);
                if (ms == null) {
                    throw new MessageRemovedException("Messages have been removed");
                }
                p.storeLabels(ms, labels, set);
            }
            catch (ConnectionException cex) {
                throw new FolderClosedException((Folder)this, cex.getMessage());
            }
            catch (ProtocolException pex) {
                throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
            }
        }
    }

    public synchronized void setLabels(int start, int end, String[] labels, boolean set) throws MessagingException {
        this.checkOpened();
        Message[] msgs = new Message[end - start + 1];
        int i = 0;
        for (int n = start; n <= end; ++n) {
            msgs[i++] = this.getMessage(n);
        }
        this.setLabels(msgs, labels, set);
    }

    public synchronized void setLabels(int[] msgnums, String[] labels, boolean set) throws MessagingException {
        this.checkOpened();
        Message[] msgs = new Message[msgnums.length];
        for (int i = 0; i < msgnums.length; ++i) {
            msgs[i] = this.getMessage(msgnums[i]);
        }
        this.setLabels(msgs, labels, set);
    }

    protected GmailFolder(String fullName, char separator, IMAPStore store, Boolean isNamespace) {
        super(fullName, separator, store, isNamespace);
    }

    protected GmailFolder(ListInfo li, IMAPStore store) {
        super(li, store);
    }

    protected IMAPMessage newIMAPMessage(int msgnum) {
        return new GmailMessage(this, msgnum);
    }

    public static class FetchProfileItem
    extends FetchProfile.Item {
        public static final FetchProfileItem MSGID = new FetchProfileItem("X-GM-MSGID");
        public static final FetchProfileItem THRID = new FetchProfileItem("X-GM-THRID");
        public static final FetchProfileItem LABELS = new FetchProfileItem("X-GM-LABELS");

        protected FetchProfileItem(String name) {
            super(name);
        }
    }
}

