/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.test.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.collection.VersionFilter;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TestVersionFilterContext
implements VersionFilter.VersionFilterContext {
    private final RepositorySystemSession session;
    private final Dependency dependency;
    private final VersionRangeResult result;
    private final List<Version> versions;

    public TestVersionFilterContext(RepositorySystemSession session, VersionRangeResult result) {
        this.session = session;
        this.result = result;
        this.dependency = new Dependency(result.getRequest().getArtifact(), "");
        this.versions = new ArrayList<Version>(result.getVersions());
    }

    public RepositorySystemSession getSession() {
        return this.session;
    }

    public Dependency getDependency() {
        return this.dependency;
    }

    public int getCount() {
        return this.versions.size();
    }

    public Iterator<Version> iterator() {
        return this.versions.iterator();
    }

    public VersionConstraint getVersionConstraint() {
        return this.result.getVersionConstraint();
    }

    public ArtifactRepository getRepository(Version version) {
        return this.result.getRepository(version);
    }

    public List<RemoteRepository> getRepositories() {
        return Collections.unmodifiableList(this.result.getRequest().getRepositories());
    }
}

