/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.test.util;

import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.internal.test.util.ArtifactDescription;
import org.eclipse.aether.internal.test.util.IniArtifactDataReader;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;

public class IniArtifactDescriptorReader {
    private IniArtifactDataReader reader;

    public IniArtifactDescriptorReader(String prefix) {
        this.reader = new IniArtifactDataReader(prefix);
    }

    public ArtifactDescriptorResult readArtifactDescriptor(RepositorySystemSession session, ArtifactDescriptorRequest request) throws ArtifactDescriptorException {
        Artifact artifact = request.getArtifact();
        String resourceName = String.format("%s_%s_%s_%s.ini", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getExtension());
        ArtifactDescriptorResult result = new ArtifactDescriptorResult(request);
        result.setArtifact(artifact);
        try {
            ArtifactDescription data = this.reader.parse(resourceName);
            result.setDependencies(data.getDependencies());
            result.setManagedDependencies(data.getManagedDependencies());
            result.setRepositories(data.getRepositories());
            result.setRelocations(data.getRelocations());
            return result;
        }
        catch (Exception e) {
            throw new ArtifactDescriptorException(result, e.getMessage());
        }
    }
}

