/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.test.impl;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.eclipse.aether.spi.io.FileProcessor;

public class TestFileProcessor
implements FileProcessor {
    public static final FileProcessor INSTANCE = new TestFileProcessor();

    private static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean mkdirs(File directory) {
        if (directory == null) {
            return false;
        }
        if (directory.exists()) {
            return false;
        }
        if (directory.mkdir()) {
            return true;
        }
        File canonDir = null;
        try {
            canonDir = directory.getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        File parentDir = canonDir.getParentFile();
        return parentDir != null && (this.mkdirs(parentDir) || parentDir.exists()) && canonDir.mkdir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file, String data) throws IOException {
        this.mkdirs(file.getParentFile());
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            if (data != null) {
                fos.write(data.getBytes("UTF-8"));
            }
            fos.close();
        }
        catch (Throwable throwable) {
            TestFileProcessor.close(fos);
            throw throwable;
        }
        TestFileProcessor.close(fos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File target, InputStream source) throws IOException {
        this.mkdirs(target.getAbsoluteFile().getParentFile());
        BufferedOutputStream fos = null;
        try {
            fos = new BufferedOutputStream(new FileOutputStream(target));
            this.copy(fos, source, null);
            ((OutputStream)fos).close();
        }
        catch (Throwable throwable) {
            TestFileProcessor.close(fos);
            throw throwable;
        }
        TestFileProcessor.close(fos);
    }

    public void copy(File source, File target) throws IOException {
        this.copy(source, target, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long copy(File source, File target, FileProcessor.ProgressListener listener) throws IOException {
        long total = 0L;
        FileInputStream fis = null;
        BufferedOutputStream fos = null;
        try {
            fis = new FileInputStream(source);
            this.mkdirs(target.getAbsoluteFile().getParentFile());
            fos = new BufferedOutputStream(new FileOutputStream(target));
            total = this.copy(fos, fis, listener);
            ((OutputStream)fos).close();
        }
        catch (Throwable throwable) {
            TestFileProcessor.close(fis);
            TestFileProcessor.close(fos);
            throw throwable;
        }
        TestFileProcessor.close(fis);
        TestFileProcessor.close(fos);
        return total;
    }

    private long copy(OutputStream os, InputStream is, FileProcessor.ProgressListener listener) throws IOException {
        int bytes;
        long total = 0L;
        ByteBuffer buffer = ByteBuffer.allocate(32768);
        byte[] array = buffer.array();
        while ((bytes = is.read(array)) >= 0) {
            os.write(array, 0, bytes);
            total += (long)bytes;
            if (listener == null || bytes <= 0) continue;
            try {
                buffer.rewind();
                buffer.limit(bytes);
                listener.progressed(buffer);
            }
            catch (Exception e) {}
        }
        return total;
    }

    public void move(File source, File target) throws IOException {
        target.delete();
        if (!source.renameTo(target)) {
            this.copy(source, target);
            target.setLastModified(source.lastModified());
            source.delete();
        }
    }
}

