/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.test.impl;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordingTransferListener
implements TransferListener {
    private List<TransferEvent> events = Collections.synchronizedList(new ArrayList());
    private List<TransferEvent> progressEvents = Collections.synchronizedList(new ArrayList());
    private TransferListener realListener;

    public RecordingTransferListener() {
        this(null);
    }

    public RecordingTransferListener(TransferListener transferListener) {
        this.realListener = transferListener;
    }

    public List<TransferEvent> getEvents() {
        return this.events;
    }

    public List<TransferEvent> getProgressEvents() {
        return this.progressEvents;
    }

    public void transferSucceeded(TransferEvent event) {
        this.events.add(event);
        if (this.realListener != null) {
            this.realListener.transferSucceeded(event);
        }
    }

    public void transferStarted(TransferEvent event) throws TransferCancelledException {
        this.events.add(event);
        if (this.realListener != null) {
            this.realListener.transferStarted(event);
        }
    }

    public void transferProgressed(TransferEvent event) throws TransferCancelledException {
        event = this.deepClone(event);
        this.events.add(event);
        this.progressEvents.add(event);
        if (this.realListener != null) {
            this.realListener.transferProgressed(event);
        }
    }

    private TransferEvent deepClone(TransferEvent event) {
        TransferEvent.Builder builder = new TransferEvent.Builder(event.getSession(), event.getResource());
        builder.setType(event.getType()).setRequestType(event.getRequestType());
        builder.setException(event.getException());
        ByteBuffer buffer = event.getDataBuffer();
        if (buffer != null) {
            builder.setDataBuffer((ByteBuffer)ByteBuffer.allocate(buffer.remaining()).put(buffer).flip());
        }
        return builder.build();
    }

    public void transferInitiated(TransferEvent event) throws TransferCancelledException {
        this.events.add(event);
        if (this.realListener != null) {
            this.realListener.transferInitiated(event);
        }
    }

    public void transferFailed(TransferEvent event) {
        this.events.add(event);
        if (this.realListener != null) {
            this.realListener.transferFailed(event);
        }
    }

    public void transferCorrupted(TransferEvent event) throws TransferCancelledException {
        this.events.add(event);
        if (this.realListener != null) {
            this.realListener.transferCorrupted(event);
        }
    }

    public void clear() {
        this.events.clear();
        this.progressEvents.clear();
    }
}

