/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.installation;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.metadata.Metadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InstallResult {
    private final InstallRequest request;
    private Collection<Artifact> artifacts = new ArrayList<Artifact>();
    private Collection<Metadata> metadata = new ArrayList<Metadata>();

    public InstallResult(InstallRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("install request has not been specified");
        }
        this.request = request;
    }

    public InstallRequest getRequest() {
        return this.request;
    }

    public Collection<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public InstallResult setArtifacts(Collection<Artifact> artifacts) {
        this.artifacts = artifacts == null ? new ArrayList<Artifact>() : artifacts;
        return this;
    }

    public InstallResult addArtifact(Artifact artifact) {
        if (artifact != null) {
            this.artifacts.add(artifact);
        }
        return this;
    }

    public Collection<Metadata> getMetadata() {
        return this.metadata;
    }

    public InstallResult setMetadata(Collection<Metadata> metadata) {
        this.metadata = metadata == null ? new ArrayList<Metadata>() : metadata;
        return this;
    }

    public InstallResult addMetadata(Metadata metadata) {
        if (metadata != null) {
            this.metadata.add(metadata);
        }
        return this;
    }

    public String toString() {
        return this.getArtifacts() + ", " + this.getMetadata();
    }
}

