/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.lint.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ec4j.lint.api.FormatException;
import org.ec4j.lint.api.Logger;
import org.ec4j.lint.api.Resource;
import org.ec4j.lint.api.Violation;
import org.ec4j.lint.api.ViolationHandler;

public class ViolationCollector
implements ViolationHandler {
    private final String correctiveAction;
    private Resource currentFile;
    private final boolean failOnFormatViolation;
    private final Logger log;
    private int processedFileCount = 0;
    private final Map<Resource, List<Violation>> violations = new LinkedHashMap<Resource, List<Violation>>();

    public ViolationCollector(boolean failOnFormatViolation, String correctiveAction, Logger log) {
        this.failOnFormatViolation = failOnFormatViolation;
        this.correctiveAction = correctiveAction;
        this.log = log;
    }

    @Override
    public ViolationHandler.ReturnState endFile() {
        if (this.log.isDebugEnabled() && !this.hasViolations(this.currentFile)) {
            this.log.debug("No formatting violations found in file '{}'", this.currentFile);
        }
        this.currentFile = null;
        ++this.processedFileCount;
        return ViolationHandler.ReturnState.FINISHED;
    }

    @Override
    public void endFiles() {
        this.log.info("Checked {} {}", this.processedFileCount, this.processedFileCount == 1 ? "file" : "files");
        if (this.failOnFormatViolation && this.hasViolations()) {
            throw new FormatException("There are .editorconfig violations. You may want to run\n\n    " + this.correctiveAction + "\n\nto fix them automagically.");
        }
    }

    @Override
    public Logger getLogger() {
        return this.log;
    }

    public Map<Resource, List<Violation>> getViolations() {
        return Collections.unmodifiableMap(this.violations);
    }

    @Override
    public void handle(Violation violation) {
        List<Violation> list = this.violations.get(violation.getResource());
        if (list == null) {
            list = new ArrayList<Violation>();
            this.violations.put(violation.getResource(), list);
        }
        list.add(violation);
        if (this.failOnFormatViolation) {
            this.log.error(violation.toString(), new Object[0]);
        } else {
            this.log.warn(violation.toString(), new Object[0]);
        }
    }

    public boolean hasViolations() {
        return !this.violations.isEmpty();
    }

    public boolean hasViolations(Resource resource) {
        List<Violation> list = this.violations.get(resource);
        return list != null && !list.isEmpty();
    }

    @Override
    public void startFile(Resource file) {
        this.currentFile = file;
    }

    @Override
    public void startFiles() {
        this.processedFileCount = 0;
    }
}

